/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.world.forge.ModWorldGenerationImpl;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class ModWorldGeneration {
    private static final Set<ResourceLocation> SUNFLOWER_IDS = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> SUNFLOWER_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> GREEN_BEAN_BUSH_IDS = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> GREEN_BEAN_BUSH_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<TagKey<Biome>> GREEN_BEAN_BUSH_CONVENTION_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> GREEN_BEAN_BUSH_EXCLUSIONS = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> CUCUMBER_BUSH_IDS = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> CUCUMBER_BUSH_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<TagKey<Biome>> CUCUMBER_BUSH_CONVENTION_TAGS = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> CUCUMBER_BUSH_EXCLUSIONS = new HashSet<ResourceLocation>();

    public static void generateModWorldGen() {
        AdorableHamsterPets.LOGGER.info("Registering Biome Modifications for adorablehamsterpets");
        ModWorldGeneration.registerBiomeModifications();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBiomeModifications() {
        ModWorldGenerationImpl.registerBiomeModifications();
    }

    public static void parseConfig() {
        SUNFLOWER_IDS.clear();
        SUNFLOWER_TAGS.clear();
        GREEN_BEAN_BUSH_IDS.clear();
        GREEN_BEAN_BUSH_TAGS.clear();
        GREEN_BEAN_BUSH_CONVENTION_TAGS.clear();
        GREEN_BEAN_BUSH_EXCLUSIONS.clear();
        CUCUMBER_BUSH_IDS.clear();
        CUCUMBER_BUSH_TAGS.clear();
        CUCUMBER_BUSH_CONVENTION_TAGS.clear();
        CUCUMBER_BUSH_EXCLUSIONS.clear();
        Configs.AHP_WORLDGEN.sunflowerBiomes.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, SUNFLOWER_IDS, "sunflowerBiomes"));
        Configs.AHP_WORLDGEN.sunflowerBiomeTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, SUNFLOWER_TAGS, "sunflowerBiomeTags"));
        Configs.AHP_WORLDGEN.greenBeanBushBiomes.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, GREEN_BEAN_BUSH_IDS, "greenBeanBushBiomes"));
        Configs.AHP_WORLDGEN.greenBeanBushTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, GREEN_BEAN_BUSH_TAGS, "greenBeanBushTags"));
        Configs.AHP_WORLDGEN.greenBeanBushConventionTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, GREEN_BEAN_BUSH_CONVENTION_TAGS, "greenBeanBushConventionTags"));
        Configs.AHP_WORLDGEN.greenBeanBushExclusions.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, GREEN_BEAN_BUSH_EXCLUSIONS, "greenBeanBushExclusions"));
        Configs.AHP_WORLDGEN.cucumberBushBiomes.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, CUCUMBER_BUSH_IDS, "cucumberBushBiomes"));
        Configs.AHP_WORLDGEN.cucumberBushTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, CUCUMBER_BUSH_TAGS, "cucumberBushTags"));
        Configs.AHP_WORLDGEN.cucumberBushConventionTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, CUCUMBER_BUSH_CONVENTION_TAGS, "cucumberBushConventionTags"));
        Configs.AHP_WORLDGEN.cucumberBushExclusions.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, CUCUMBER_BUSH_EXCLUSIONS, "cucumberBushExclusions"));
        AdorableHamsterPets.LOGGER.info("[FeatureConfig] Parsed feature generation settings from config.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldFeatureSpawnInBiome(Holder<PlacedFeature> feature, Holder<Biome> biome) {
        boolean bl;
        String featurePath;
        ResourceLocation featureId = feature.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        ResourceLocation biomeId = biome.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (featureId == null) return false;
        if (biomeId == null) {
            return false;
        }
        switch (featurePath = featureId.m_135815_()) {
            case "custom_sunflower_placed": 
            case "patch_sunflower": {
                Holder entry;
                if (!SUNFLOWER_IDS.contains(biomeId)) {
                    if (!SUNFLOWER_TAGS.stream().anyMatch(arg_0 -> biome.m_203656_(arg_0))) return false;
                }
                boolean bl2 = true;
                boolean isAllowedByConfig = bl2;
                if (!isAllowedByConfig) {
                    return false;
                }
                List allFeaturesByStep = ((Biome)biome.m_203334_()).m_47536_().m_47818_();
                int vegetalStep = GenerationStep.Decoration.VEGETAL_DECORATION.ordinal();
                if (vegetalStep >= allFeaturesByStep.size()) {
                    return false;
                }
                HolderSet vegetalFeatures = (HolderSet)allFeaturesByStep.get(vegetalStep);
                Iterator iterator = vegetalFeatures.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!(entry = (Holder)iterator.next()).m_203565_(VegetationPlacements.f_195449_));
                bl = true;
                break;
            }
            case "wild_green_bean_bush_placed": {
                if (!GREEN_BEAN_BUSH_IDS.contains(biomeId)) {
                    if (!GREEN_BEAN_BUSH_TAGS.stream().anyMatch(arg_0 -> biome.m_203656_(arg_0))) {
                        if (!GREEN_BEAN_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> biome.m_203656_(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            case "wild_cucumber_bush_placed": {
                if (!CUCUMBER_BUSH_IDS.contains(biomeId)) {
                    if (!CUCUMBER_BUSH_TAGS.stream().anyMatch(arg_0 -> biome.m_203656_(arg_0))) {
                        if (!CUCUMBER_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> biome.m_203656_(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        boolean isCandidate = bl;
        if (!isCandidate) {
            return false;
        }
        switch (featurePath) {
            case "wild_green_bean_bush_placed": {
                if (GREEN_BEAN_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            case "wild_cucumber_bush_placed": {
                if (CUCUMBER_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            default: {
                return true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldFeatureSpawnInBiome(ResourceKey<PlacedFeature> featureKey, BiomeModifications.BiomeContext context) {
        boolean bl;
        String featurePath;
        ResourceLocation biomeId = context.getKey().orElse(null);
        if (biomeId == null) {
            return false;
        }
        switch (featurePath = featureKey.m_135782_().m_135815_()) {
            case "custom_sunflower_placed": 
            case "patch_sunflower": {
                if (!SUNFLOWER_IDS.contains(biomeId)) {
                    if (!SUNFLOWER_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) return false;
                }
                bl = true;
                break;
            }
            case "wild_green_bean_bush_placed": {
                if (!GREEN_BEAN_BUSH_IDS.contains(biomeId)) {
                    if (!GREEN_BEAN_BUSH_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) {
                        if (!GREEN_BEAN_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            case "wild_cucumber_bush_placed": {
                if (!CUCUMBER_BUSH_IDS.contains(biomeId)) {
                    if (!CUCUMBER_BUSH_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) {
                        if (!CUCUMBER_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        boolean isCandidate = bl;
        if (!isCandidate) {
            return false;
        }
        switch (featurePath) {
            case "wild_green_bean_bush_placed": {
                if (GREEN_BEAN_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            case "wild_cucumber_bush_placed": {
                if (CUCUMBER_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            default: {
                return true;
            }
        }
    }

    private static void parseIdentifier(String idStr, Set<ResourceLocation> set, String configListName) {
        try {
            set.add(new ResourceLocation(idStr));
        }
        catch (Exception e) {
            AdorableHamsterPets.LOGGER.info("[FeatureConfig] Invalid identifier in '{}' config list: '{}'", (Object)configListName, (Object)idStr);
        }
    }

    private static void parseTag(String tagStr, Set<TagKey<Biome>> set, String configListName) {
        try {
            set.add((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(tagStr)));
        }
        catch (Exception e) {
            AdorableHamsterPets.LOGGER.info("[FeatureConfig] Invalid biome tag identifier in '{}' config list: '{}'", (Object)configListName, (Object)tagStr);
        }
    }
}

