/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleBreadcrumbHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class HamsterSeekDiamondGoal
extends Goal {
    private final HamsterEntity hamster;
    private final Level world;
    private BlockPos targetOrePos;
    private boolean isSeekingGold;
    private SeekingState currentState = SeekingState.IDLE;
    private int pathingTickTimer;
    private int soundTimer;
    @Nullable
    private Path path;
    private static final int PATHING_RECHECK_INTERVAL = 20;
    private static final int SNIFF_SOUND_INTERVAL_MOVING = 30;
    private static final int SNIFF_SOUND_INTERVAL_WAITING = 160;

    public HamsterSeekDiamondGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.world.f_46443_ || !Configs.AHP.enableIndependentDiamondSeeking) {
            return false;
        }
        if (!this.hamster.isPrimedToSeekDiamonds) {
            return false;
        }
        if (this.hamster.m_21827_() || this.hamster.m_5803_() || this.hamster.isKnockedOut() || this.hamster.isCelebratingChase() || this.hamster.isSulking()) {
            return false;
        }
        if (this.hamster.m_5448_() != null) {
            return false;
        }
        if (Configs.AHP.enableIndependentDiamondSeekCooldown && this.hamster.foundOreCooldownEndTick > this.world.m_46467_()) {
            return false;
        }
        return this.findNewTargetOreAndSetState();
    }

    private boolean findNewTargetOreAndSetState() {
        boolean targetIsGold;
        this.targetOrePos = null;
        this.isSeekingGold = false;
        this.hamster.currentOreTarget = null;
        ArrayList<BlockPos> exposedDiamondOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedDiamondOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedGoldOres = new ArrayList<BlockPos>();
        int radius = (Integer)Configs.AHP.diamondSeekRadius.get();
        for (BlockPos pos2 : BlockPos.m_121925_((BlockPos)this.hamster.m_20183_(), (int)radius, (int)radius, (int)radius)) {
            BlockState state = this.world.m_8055_(pos2);
            Block block = state.m_60734_();
            if (block == Blocks.f_50089_ || block == Blocks.f_152474_) {
                if (HamsterSeekDiamondGoal.isOreExposed(pos2, this.world)) {
                    exposedDiamondOres.add(pos2.m_7949_());
                    continue;
                }
                buriedDiamondOres.add(pos2.m_7949_());
                continue;
            }
            if (block != Blocks.f_49995_ && block != Blocks.f_152467_ || !HamsterSeekDiamondGoal.isOreExposed(pos2, this.world)) continue;
            buriedGoldOres.add(pos2.m_7949_());
        }
        boolean bl = targetIsGold = !buriedGoldOres.isEmpty() && this.world.f_46441_.m_188501_() < ((Float)Configs.AHP.goldMistakeChance.get()).floatValue();
        if (targetIsGold) {
            buriedGoldOres.sort(Comparator.comparingDouble(pos -> pos.m_203193_((Position)this.hamster.m_20182_())));
            this.targetOrePos = (BlockPos)buriedGoldOres.get(0);
            this.isSeekingGold = true;
        } else if (!exposedDiamondOres.isEmpty()) {
            exposedDiamondOres.sort(Comparator.comparingDouble(pos -> pos.m_203193_((Position)this.hamster.m_20182_())));
            this.targetOrePos = (BlockPos)exposedDiamondOres.get(0);
        } else if (!buriedDiamondOres.isEmpty()) {
            buriedDiamondOres.sort(Comparator.comparingDouble(pos -> pos.m_203193_((Position)this.hamster.m_20182_())));
            this.targetOrePos = (BlockPos)buriedDiamondOres.get(0);
        }
        if (this.targetOrePos != null) {
            this.hamster.currentOreTarget = this.targetOrePos;
            this.currentState = SeekingState.SCANNING;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.isSeekingGold ? "_Gold" : "_Diamond"));
        this.pathingTickTimer = 0;
        this.soundTimer = 0;
        this.attemptPathToTarget();
    }

    private void attemptPathToTarget() {
        if (this.targetOrePos == null) {
            this.currentState = SeekingState.IDLE;
            return;
        }
        this.path = this.hamster.m_21573_().m_26524_((double)this.targetOrePos.m_123341_() + 0.5, (double)this.targetOrePos.m_123342_(), (double)this.targetOrePos.m_123343_() + 0.5, 0);
        if (this.path != null) {
            this.hamster.m_21573_().m_26536_(this.path, 0.5);
            this.currentState = SeekingState.MOVING_TO_ORE;
            this.soundTimer = 15;
        } else {
            this.currentState = SeekingState.WAITING_FOR_PATH;
            this.pathingTickTimer = 20;
            this.soundTimer = 80;
        }
    }

    public boolean m_8045_() {
        boolean isTargetGold;
        if (this.currentState == SeekingState.IDLE || this.currentState == SeekingState.CELEBRATING_DIAMOND || this.currentState == SeekingState.SULKING_AT_GOLD) {
            return false;
        }
        if (this.hamster.m_21827_() || this.hamster.m_5803_() || this.hamster.isKnockedOut() || this.hamster.isSulking()) {
            return false;
        }
        if (this.hamster.m_5448_() != null) {
            return false;
        }
        if (this.targetOrePos == null) {
            return false;
        }
        Block targetBlock = this.world.m_8055_(this.targetOrePos).m_60734_();
        boolean isTargetDiamond = targetBlock == Blocks.f_50089_ || targetBlock == Blocks.f_152474_;
        boolean bl = isTargetGold = targetBlock == Blocks.f_49995_ || targetBlock == Blocks.f_152467_;
        if (this.isSeekingGold) {
            return isTargetGold;
        }
        return isTargetDiamond;
    }

    public void m_8037_() {
        if (this.targetOrePos == null) {
            this.m_8041_();
            return;
        }
        this.hamster.m_21563_().m_24950_((double)this.targetOrePos.m_123341_() + 0.5, (double)this.targetOrePos.m_123342_() + 0.5, (double)this.targetOrePos.m_123343_() + 0.5, 25.0f, 25.0f);
        if (this.soundTimer > 0) {
            --this.soundTimer;
        }
        switch (this.currentState) {
            case MOVING_TO_ORE: {
                if (!this.world.m_5776_()) {
                    ParticleBreadcrumbHelper.spawnBreadcrumbs((ServerLevel)this.world, this.path);
                }
                if (this.hamster.m_21573_().m_26571_() || this.hamster.m_20183_().m_123314_((Vec3i)this.targetOrePos, 1.5)) {
                    if (this.hamster.m_20183_().m_123314_((Vec3i)this.targetOrePos, 1.5)) {
                        this.onOreReached();
                        break;
                    }
                    this.path = null;
                    this.currentState = SeekingState.WAITING_FOR_PATH;
                    this.pathingTickTimer = 20;
                    this.soundTimer = 80;
                    break;
                }
                if (this.soundTimer > 0) break;
                this.playSniffSound();
                this.soundTimer = 30;
                break;
            }
            case WAITING_FOR_PATH: {
                if (this.pathingTickTimer > 0) {
                    --this.pathingTickTimer;
                } else {
                    this.attemptPathToTarget();
                }
                if (this.soundTimer > 0) break;
                this.playSniffSound();
                this.soundTimer = 160;
            }
        }
    }

    private void onOreReached() {
        this.hamster.m_21573_().m_26573_();
        this.hamster.isPrimedToSeekDiamonds = false;
        if (Configs.AHP.enableIndependentDiamondSeekCooldown) {
            this.hamster.foundOreCooldownEndTick = this.world.m_46467_() + (long)((Integer)Configs.AHP.independentOreSeekCooldownTicks.get()).intValue();
        }
        if (this.isSeekingGold) {
            this.currentState = SeekingState.SULKING_AT_GOLD;
            LivingEntity livingEntity = this.hamster.m_269323_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer owner = (ServerPlayer)livingEntity;
                if (this.hamster.m_20280_((Entity)owner) < 36.0) {
                    this.hamster.m_21563_().m_24960_((Entity)owner, 25.0f, 25.0f);
                }
                this.sendMessageToOwner(owner);
            }
            Vec3 awayFromOre = this.hamster.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)this.targetOrePos)).m_82541_();
            this.hamster.m_20334_(awayFromOre.f_82479_ * 0.1, 0.5, awayFromOre.f_82481_ * 0.1);
            this.hamster.f_19812_ = true;
            SoundEvent bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, this.hamster.m_217043_());
            if (bounceSound != null) {
                this.world.m_5594_(null, this.hamster.m_20183_(), bounceSound, SoundSource.NEUTRAL, 0.6f, this.hamster.m_6100_());
            }
            this.hamster.setSulking(true);
            this.hamster.triggerAnimOnServer("mainController", "anim_hamster_sulk");
        } else {
            this.currentState = SeekingState.CELEBRATING_DIAMOND;
            this.hamster.setCelebratingDiamond(true);
            AdorableHamsterPets.LOGGER.trace("Hamster {} reached CELEBRATING_DIAMOND state for ore at {}", (Object)this.hamster.m_19879_(), (Object)this.targetOrePos);
            LivingEntity livingEntity = this.hamster.m_269323_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                ModCriteria.HAMSTER_LED_TO_DIAMOND.trigger(serverPlayerOwner, this.hamster, this.targetOrePos);
            }
        }
    }

    private void playSniffSound() {
        SoundEvent sniffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, this.hamster.m_217043_());
        if (sniffSound != null) {
            this.world.m_5594_(null, this.hamster.m_20183_(), sniffSound, SoundSource.NEUTRAL, 3.0f, this.hamster.m_6100_());
        }
    }

    public void m_8041_() {
        this.path = null;
        this.hamster.m_21573_().m_26573_();
        boolean targetOreStillExists = false;
        if (this.targetOrePos != null) {
            boolean isTargetGold;
            Block targetBlock = this.world.m_8055_(this.targetOrePos).m_60734_();
            boolean isTargetDiamond = targetBlock == Blocks.f_50089_ || targetBlock == Blocks.f_152474_;
            boolean bl = isTargetGold = targetBlock == Blocks.f_49995_ || targetBlock == Blocks.f_152467_;
            if (this.isSeekingGold && isTargetGold) {
                targetOreStillExists = true;
            }
            if (!this.isSeekingGold && isTargetDiamond) {
                targetOreStillExists = true;
            }
        }
        if (this.currentState != SeekingState.CELEBRATING_DIAMOND && this.currentState != SeekingState.SULKING_AT_GOLD && !targetOreStillExists) {
            this.hamster.isPrimedToSeekDiamonds = false;
        }
        if (this.hamster.isCelebratingDiamond() && (this.currentState != SeekingState.CELEBRATING_DIAMOND || !targetOreStillExists)) {
            this.hamster.setCelebratingDiamond(false);
        }
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.currentState = SeekingState.IDLE;
        this.targetOrePos = null;
    }

    private void sendMessageToOwner(ServerPlayer owner) {
        int messageIndex;
        PlayerAdvancements tracker = owner.m_8960_();
        ResourceLocation advId = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"technical/hamster_found_gold_first_time");
        Advancement advancement = owner.f_8924_.m_129889_().m_136041_(advId);
        if (advancement == null) {
            AdorableHamsterPets.LOGGER.error("[GoldMessage] CRITICAL: Could not find advancement '{}'. Message will not be sent. Check file path and JSON validity.", (Object)advId);
            return;
        }
        AdvancementProgress progress = tracker.m_135996_(advancement);
        if (!progress.m_8193_()) {
            messageIndex = 0;
            for (String criterion : advancement.m_138325_().keySet()) {
                tracker.m_135988_(advancement, criterion);
            }
        } else {
            PlayerEntityAccessor accessor = (PlayerEntityAccessor)owner;
            int lastIndex = accessor.ahp_getLastGoldMessageIndex();
            List possibleIndices = IntStream.range(0, 7).boxed().collect(Collectors.toList());
            if (lastIndex >= 0 && lastIndex < 7) {
                possibleIndices.remove((Object)lastIndex);
            }
            messageIndex = (Integer)possibleIndices.get(this.world.f_46441_.m_188503_(possibleIndices.size()));
        }
        ((PlayerEntityAccessor)owner).ahp_setLastGoldMessageIndex(messageIndex);
        String messageKey = "message.adorablehamsterpets.found_gold_mistake." + (messageIndex + 1);
        owner.m_5661_((Component)Component.m_237115_((String)messageKey).m_130940_(ChatFormatting.GOLD), true);
        ModCriteria.HAMSTER_FOUND_GOLD.trigger(owner);
    }

    public static boolean isOreExposed(BlockPos orePos, Level world) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos = orePos.m_121945_(direction);
            if (!world.m_8055_(adjacentPos).m_60742_((BlockGetter)world, adjacentPos, CollisionContext.m_82749_()).m_83281_()) continue;
            return true;
        }
        return false;
    }

    private static enum SeekingState {
        IDLE,
        SCANNING,
        MOVING_TO_ORE,
        WAITING_FOR_PATH,
        CELEBRATING_DIAMOND,
        SULKING_AT_GOLD;

    }
}

