/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlockEntities;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HamsterBedBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final BooleanProperty OCCUPIED = BooleanProperty.m_61465_((String)"occupied");
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.m_61465_((String)"upside_down");
    public static final DirectionProperty ORIENTATION = DirectionProperty.m_61546_((String)"orientation", dir -> dir.m_122434_().m_122479_());
    public static final EnumProperty<WoodVariant> WOOD_VARIANT = EnumProperty.m_61587_((String)"wood_variant", WoodVariant.class);
    private static final VoxelShape SHAPE_NORMAL = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0), Block.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0)).reduce(Shapes::m_83110_).get();
    private static final VoxelShape SHAPE_UPSIDE_DOWN = Stream.of(Block.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.m_49796_((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)13.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)14.0, (double)13.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0)).reduce(Shapes::m_83110_).get();

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_UPSIDE_DOWN : SHAPE_NORMAL;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_UPSIDE_DOWN : SHAPE_NORMAL;
    }

    public HamsterBedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ORIENTATION, (Comparable)Direction.NORTH)).m_61124_(WOOD_VARIANT, (Comparable)((Object)WoodVariant.OAK)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HamsterBedBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OCCUPIED, UPSIDE_DOWN, ORIENTATION, WOOD_VARIANT});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean isUpsideDown = ctx.m_43719_() == Direction.DOWN;
        WoodVariant variant = WoodVariant.OAK;
        ItemStack stack = ctx.m_43722_();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("WoodVariant")) {
            try {
                variant = WoodVariant.valueOf(stack.m_41783_().m_128461_("WoodVariant"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        BlockPos pos = ctx.m_8083_();
        long s = pos.m_121878_() ^ 0x9E3779B97F4A7C15L;
        s ^= s >>> 30;
        s *= -4658895280553007687L;
        s ^= s >>> 27;
        s *= -7723592293110705685L;
        s ^= s >>> 31;
        int idx = (int)(s & 3L);
        Direction direction = Direction.m_122407_((int)idx);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(isUpsideDown))).m_61124_((Property)ORIENTATION, (Comparable)direction)).m_61124_(WOOD_VARIANT, (Comparable)((Object)variant));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            HamsterBedBlockEntity bedEntity;
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof HamsterBedBlockEntity) {
                CompoundTag nbt;
                bedEntity = (HamsterBedBlockEntity)be;
                if (((Boolean)state.m_61143_((Property)UPSIDE_DOWN)).booleanValue()) {
                    bedEntity.setAllowSleep(false);
                    if (placer instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)placer;
                        ModCriteria.HAMSTER_BED_PLACED_UPSIDE_DOWN.trigger(serverPlayer);
                    }
                }
                if (itemStack.m_41782_() && (nbt = itemStack.m_41783_()).m_128441_("LinkedHamsterUuid")) {
                    UUID hamsterUuid = nbt.m_128342_("LinkedHamsterUuid");
                    MutableComponent hamsterName = null;
                    if (nbt.m_128441_("LinkedHamsterName")) {
                        hamsterName = Component.Serializer.m_130701_((String)nbt.m_128461_("LinkedHamsterName"));
                    }
                    WanderDistance wanderDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                    if (nbt.m_128441_("WanderDistance")) {
                        try {
                            wanderDistance = WanderDistance.valueOf(nbt.m_128461_("WanderDistance"));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    bedEntity.setLinkedHamster(hamsterUuid, (Component)(hamsterName != null ? hamsterName : Component.m_237113_((String)"Hamster")), wanderDistance);
                    Entity entity = ((ServerLevel)world).m_8791_(hamsterUuid);
                    if (entity instanceof HamsterEntity) {
                        HamsterEntity hamster = (HamsterEntity)entity;
                        hamster.setLinkedBedPos(Optional.of(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos)));
                        hamster.setWanderModeActive(true);
                    }
                }
            }
            if (be instanceof HamsterBedBlockEntity) {
                bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            ItemStack heldStack = player.m_21120_(hand);
            boolean isLureItem = ConfigDataCache.isLureItem(heldStack);
            boolean isAvoidanceItem = ConfigDataCache.isBedAvoidanceFood(heldStack);
            return isLureItem || isAvoidanceItem ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
            if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_interact_occupied");
            } else {
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_interact_unoccupied");
            }
            ((ServerLevel)world).m_8767_((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)state.m_61143_(WOOD_VARIANT))), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 30, 0.1, 0.1, 0.1, 0.0);
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.m_213780_());
            if (rustleSound != null) {
                world.m_5594_(null, pos, rustleSound, SoundSource.BLOCKS, 0.2f, 1.8f);
            }
            ItemStack heldStack = player.m_21120_(hand);
            if (player.m_6144_() && ConfigDataCache.isBedAvoidanceFood(heldStack)) {
                bedEntity.unlinkHamster(player);
                return InteractionResult.SUCCESS;
            }
            if (ConfigDataCache.isBedAvoidanceFood(heldStack)) {
                if (((Boolean)state.m_61143_((Property)OCCUPIED)).booleanValue()) {
                    bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> {
                        HamsterEntity hamster;
                        Entity entity = ((ServerLevel)world).m_8791_(uuid);
                        if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).m_5803_()) {
                            hamster.wakeUpFromBed(true);
                        }
                    });
                }
                bedEntity.applyRepellentEffect();
                player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.bed_repellent_applied").m_130940_(ChatFormatting.RED), true);
                world.m_5594_(null, pos, SoundEvents.f_11968_, SoundSource.BLOCKS, 1.2f, 0.8f);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 15, 0.4, 0.3, 0.4, 0.01);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (ConfigDataCache.isLureItem(heldStack)) {
                boolean wasRepellentActive;
                if (((Boolean)state.m_61143_((Property)UPSIDE_DOWN)).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.bed_upside_down_lure_fail").m_130940_(ChatFormatting.RED), true);
                    world.m_5594_(null, pos, SoundEvents.f_11797_, SoundSource.BLOCKS, 0.5f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                boolean bl = wasRepellentActive = !bedEntity.isSleepingAllowed();
                if (wasRepellentActive) {
                    bedEntity.setAllowSleep(true);
                }
                boolean lureWasSuccessful = bedEntity.lureHamsterToBed(player, heldStack);
                if (wasRepellentActive) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.bed_repellent_removed").m_130940_(ChatFormatting.GREEN), true);
                } else if (lureWasSuccessful) {
                    bedEntity.getLinkedHamsterName().ifPresent(name -> player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.lure_to_bed_success", (Object[])new Object[]{name}), true));
                }
                if (!player.m_150110_().f_35937_ && Configs.AHP.consumeLureItem) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_()) {
                bedEntity.cycleWanderDistance(player);
                return InteractionResult.SUCCESS;
            }
            bedEntity.toggleWanderMode(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_()) && !world.m_5776_()) {
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.m_213780_());
            if (rustleSound != null) {
                world.m_5594_(null, pos, rustleSound, SoundSource.BLOCKS, 0.3f, 1.5f);
            }
            ((ServerLevel)world).m_8767_((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)state.m_61143_(WOOD_VARIANT))), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 30, 0.1, 0.1, 0.1, 0.0);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
                ServerLevel serverWorld = (ServerLevel)world;
                bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> {
                    Entity entity = serverWorld.m_8791_(uuid);
                    if (entity instanceof HamsterEntity) {
                        LivingEntity patt15960$temp;
                        HamsterEntity hamster = (HamsterEntity)entity;
                        hamster.setWanderModeActive(false);
                        hamster.setLinkedBedPos(Optional.empty());
                        if (hamster.m_5803_()) {
                            hamster.wakeUpFromBed(true);
                        }
                        if ((patt15960$temp = hamster.m_269323_()) instanceof Player) {
                            Player owner = (Player)patt15960$temp;
                            if (Configs.AHP.enableBedBreakMessage) {
                                owner.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.bed_broken").m_130940_(ChatFormatting.RED), true);
                            }
                        }
                    }
                });
            }
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.m_5776_()) {
            return HamsterBedBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.HAMSTER_BED_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> {
                if (((Boolean)state1.m_61143_((Property)UPSIDE_DOWN)).booleanValue() && world1.f_46441_.m_188503_(35) == 0) {
                    double x = (double)pos.m_123341_() + world1.f_46441_.m_188500_();
                    double y = (double)pos.m_123342_() + 0.6;
                    double z = (double)pos.m_123343_() + world1.f_46441_.m_188500_();
                    world1.m_7106_((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)((Object)state1.m_61143_(WOOD_VARIANT)))), x, y, z, 0.0, -1.23E-4, 0.0);
                }
            });
        }
        return null;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        WoodVariant variant = (WoodVariant)((Object)state.m_61143_(WOOD_VARIANT));
        Item item = (Item)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        return new ItemStack((ItemLike)item);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        WoodVariant variant = (WoodVariant)((Object)state.m_61143_(WOOD_VARIANT));
        Item itemToDrop = (Item)ModItems.HAMSTER_BED_ITEMS.get((Object)variant).get();
        ItemStack stack = new ItemStack((ItemLike)itemToDrop);
        BlockEntity blockEntity = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        if (blockEntity instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)blockEntity;
            CompoundTag nbt = stack.m_41784_();
            bedEntity.getLinkedHamsterUuid().ifPresent(uuid -> nbt.m_128362_("LinkedHamsterUuid", uuid));
            bedEntity.getLinkedHamsterName().ifPresent(name -> nbt.m_128359_("LinkedHamsterName", Component.Serializer.m_130703_((Component)name)));
            nbt.m_128359_("WanderDistance", bedEntity.getWanderDistance().m_7912_());
        }
        return List.of(stack);
    }
}

