/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import pigcart.particlerain.TextureUtil;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.config.Whitelist;
import pigcart.particlerain.particle.WeatherParticle;

public class StreakParticle
extends WeatherParticle {
    private final Direction direction;
    private final Whitelist.BlockList blockList;

    public StreakParticle(ClientLevel level, double x, double y, double z, Direction direction, Whitelist.BlockList blockList) {
        super(level, x, y, z, VersionUtil.getSprite(VersionUtil.getId("streak")));
        if (ConfigManager.config.compat.waterTint) {
            TextureUtil.applyWaterTint((SingleQuadParticle)this, level, (BlockPos)this.pos);
        } else {
            this.m_107253_(0.2f, 0.3f, 1.0f);
        }
        this.f_107230_ = ConfigManager.config.streak.opacity;
        this.f_107663_ = ConfigManager.config.streak.size;
        this.m_107250_(0.01f, 0.01f);
        this.f_107219_ = true;
        this.f_107216_ = -0.1;
        this.f_107231_ = (float)direction.m_122416_() * 1.5707964f;
        this.direction = direction;
        this.blockList = blockList;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (this.f_107218_) {
            this.doCollisionAnim = true;
        }
        if (this.f_107224_ % 10 == 0) {
            this.f_107226_ = this.f_107223_.m_188499_() ? this.f_107223_.m_188501_() / 10.0f : 0.0f;
        }
    }

    @Override
    public void onPositionUpdate() {
        Vec3 start = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 end = start.m_231075_(this.direction.m_122424_(), (double)0.06f);
        BlockHitResult hit = this.f_107208_.m_45547_(VersionUtil.getClipContext(start, end));
        BlockState stateBehind = this.f_107208_.m_8055_(hit.m_82425_());
        FluidState fluidState = this.f_107208_.m_6425_((BlockPos)this.pos);
        if (hit.m_6662_().equals((Object)HitResult.Type.MISS)) {
            Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123803_, this.f_107212_, this.f_107213_ - 0.05, this.f_107214_, 0.0, 0.0, 0.0);
            this.doCollisionAnim = true;
        } else if (!this.blockList.contains(stateBehind.m_222976_()) || !fluidState.m_76178_()) {
            this.doCollisionAnim = true;
        }
    }

    @Override
    public void tickCollisionAnim() {
        this.f_107226_ = 0.0f;
        this.f_107216_ = 0.0;
        this.f_107230_ -= 0.1f;
        if (this.f_107230_ <= 0.0f) {
            this.m_107274_();
        }
    }

    @Override
    public void tickDistanceFade() {
    }

    public void m_5744_(VertexConsumer h, Camera camera, float f) {
        Vec3 camPos = VersionUtil.camPos(camera);
        float x = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d((double)this.f_107231_, 0.0, 1.0, 0.0));
        this.turnBackfaceFlipways(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(h, quaternion, x, y + this.f_107663_, z, f);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new StreakParticle(level, x, y, z, Direction.m_235672_((RandomSource)level.f_46441_), new Whitelist.BlockList());
        }
    }
}

