/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.common.network;

import dev.limonblaze.originsclasses.OriginsClasses;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record S2CInfiniteTrader(boolean infiniteTrader) {
    public static S2CInfiniteTrader decode(FriendlyByteBuf buf) {
        return new S2CInfiniteTrader(buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.infiniteTrader);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleSync() {
        OriginsClasses.INFINITE_TRADER = this.infiniteTrader;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleSync));
        contextSupplier.get().setPacketHandled(true);
    }
}

