/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.manager;

import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.capture.ParticleCaptures;
import net.lopymine.pe.client.ParticleEffectsClient;
import net.lopymine.pe.compat.LoadedMods;
import net.lopymine.pe.extension.RegistryExtension;
import net.lopymine.pe.particle.TexturedParticleFactory;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.ListUtils;
import net.lopymine.pe.utils.PEStatusEffect;
import net.lopymine.pe.utils.PEType;
import net.lopymine.pe.utils.StatusEffectUtils;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsManager {
    public static boolean redirectEnabled = false;
    public static boolean redirectToVanillaEffectColors = true;
    public static final DeferredRegister<ParticleType<?>> PARTICLES_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256890_, (String)"particle_effects");
    private static final List<RegistryObject<SimpleParticleType>> REGISTERED_PARTICLE_TYPES = new ArrayList<RegistryObject<SimpleParticleType>>();
    private static final Map<MobEffect, RegistryObject<SimpleParticleType>> EFFECT_TO_PARTICLE = new HashMap<MobEffect, RegistryObject<SimpleParticleType>>();
    private static final Map<Integer, List<ParticleOptions>> COLOR_TO_PARTICLES_MAP = new HashMap<Integer, List<ParticleOptions>>();
    private static final HashMap<ParticleOptions, MobEffect> MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE = ParticleEffectsManager.getMinecraftEffectWidthTexturedParticles();

    @Nullable
    public static List<ParticleOptions> getParticleEffects(Integer i) {
        return COLOR_TO_PARTICLES_MAP.get(i);
    }

    private static void registerParticleTypeForEffect(MobEffect statusEffect, ResourceLocation effectId) {
        ResourceLocation modEffectId = ParticleEffectsManager.getModEffectId(statusEffect, effectId);
        String registryName = modEffectId.m_135815_();
        RegistryObject holder = PARTICLES_REGISTER.register(registryName, () -> new SimpleParticleType(false));
        REGISTERED_PARTICLE_TYPES.add((RegistryObject<SimpleParticleType>)holder);
        EFFECT_TO_PARTICLE.put(statusEffect, (RegistryObject<SimpleParticleType>)holder);
    }

    private static ResourceLocation getModEffectId(MobEffect statusEffect, ResourceLocation effectId) {
        boolean bl = MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.containsValue(statusEffect);
        return ParticleEffects.id(effectId.m_135815_() + (bl ? "_new" : ""));
    }

    public static void registerParticleTypes() {
        for (Holder.Reference reference : RegistryExtension.references(BuiltInRegistries.f_256974_)) {
            MobEffect statusEffect = (MobEffect)reference.m_203334_();
            ResourceLocation id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            ParticleEffectsManager.registerParticleTypeForEffect(statusEffect, id);
        }
    }

    public static void swapParticleTypes() {
        for (Map.Entry<MobEffect, RegistryObject<SimpleParticleType>> entry : EFFECT_TO_PARTICLE.entrySet()) {
            StatusEffectUtils.swapParticle(entry.getKey(), (ParticleOptions)entry.getValue().get());
        }
    }

    public static void registerParticleColorsForTypes() {
        ResourceLocation id;
        for (Holder.Reference reference : RegistryExtension.references(BuiltInRegistries.f_256980_)) {
            Potion potion = (Potion)reference.m_203334_();
            id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            List effects = potion.m_43488_();
            int color = ArgbUtils.getColorWithoutAlpha(StatusEffectUtils.getColor(effects));
            List particleEffects = effects.stream().map(MobEffectInstance::m_19544_).flatMap(effect -> {
                ParticleOptions particleEffect = ((PEStatusEffect)effect).particleEffects$getParticleEffect();
                if (particleEffect == null) {
                    ParticleEffectsClient.LOGGER.error("[DEV/Potion Registration] Looks like {} effect (from potion with color {}) doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)effect.m_19482_().getString());
                    return Stream.empty();
                }
                return Stream.of(particleEffect);
            }).toList();
            List<ParticleOptions> list = COLOR_TO_PARTICLES_MAP.get(color);
            if (list != null) {
                if (!ParticleEffects.getConfig().isDebugLogEnabled()) continue;
                String potionName = potion.f_43481_;
                ParticleEffects.LOGGER.warn("[DEV/Potion Registration] Found registered effects for color {} from {} potion, skipping its registration. If you just mod user, ignore it.", (Object)color, (Object)potionName);
                continue;
            }
            COLOR_TO_PARTICLES_MAP.put(color, particleEffects);
        }
        for (Holder.Reference reference : RegistryExtension.references(BuiltInRegistries.f_256974_)) {
            MobEffect statusEffect = (MobEffect)reference.m_203334_();
            id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            int color = ArgbUtils.getColorWithoutAlpha(statusEffect.m_19484_());
            ParticleOptions particleEffect = ((PEStatusEffect)statusEffect).particleEffects$getParticleEffect();
            if (particleEffect == null) {
                ParticleEffects.LOGGER.error("[DEV/Effect Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping its registration.", (Object)color, (Object)statusEffect.m_19482_().getString());
                continue;
            }
            List<ParticleOptions> effects = COLOR_TO_PARTICLES_MAP.get(color);
            if (effects != null) {
                if (!ParticleEffects.getConfig().isDebugLogEnabled()) continue;
                ParticleEffects.LOGGER.warn("[DEV/Effect Registration] Found registered effects for color {} from {} effect, skipping its registration. If you just mod user, ignore it.", (Object)color, (Object)statusEffect.m_19482_().getString());
                continue;
            }
            COLOR_TO_PARTICLES_MAP.put(color, List.of(particleEffect));
        }
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        for (RegistryObject<SimpleParticleType> holder : REGISTERED_PARTICLE_TYPES) {
            event.registerSpriteSet((ParticleType)holder.get(), TexturedParticleFactory::new);
        }
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ParticleEffectsManager.swapParticleTypes();
            if (LoadedMods.isAnyOldPotionsModLoaded()) {
                redirectEnabled = true;
                redirectToVanillaEffectColors = true;
                ParticleEffectsManager.registerParticleColorsForTypes();
                redirectToVanillaEffectColors = false;
                ParticleEffectsManager.registerParticleColorsForTypes();
                redirectEnabled = false;
            } else {
                ParticleEffectsManager.registerParticleColorsForTypes();
            }
        });
    }

    private static HashMap<ParticleOptions, MobEffect> getMinecraftEffectWidthTexturedParticles() {
        return new HashMap<ParticleOptions, MobEffect>();
    }

    public static MobEffect getVanillaStatusEffectByStatusEffect(ParticleOptions parameters) {
        return MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.get(parameters);
    }

    public static void processSplashPotionStageOne(LocalRef<List<ParticleOptions>> localParticleEffects, int color) {
        localParticleEffects.set(null);
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return;
        }
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return;
        }
        localParticleEffects.set(list);
    }

    public static Particle processSplashPotionStageTwo(@Nullable Level world, ParticleOptions original, Function<ParticleOptions, Particle> function, LocalRef<List<ParticleOptions>> localParticleEffects, int color) {
        Supplier<Particle> particleSupplier = () -> (Particle)function.apply(original);
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return ParticleEffectsManager.markDebugData(21, particleSupplier);
        }
        List list = (List)localParticleEffects.get();
        if (list == null) {
            return ParticleEffectsManager.markDebugData(22, particleSupplier);
        }
        if (list.isEmpty()) {
            return ParticleEffectsManager.markDebugData(23, particleSupplier);
        }
        if (world == null) {
            return ParticleEffectsManager.markDebugData(24, particleSupplier);
        }
        ParticleOptions particleEffect = (ParticleOptions)ListUtils.getRandomElement(list, world.m_213780_());
        if (particleEffect == null) {
            return ParticleEffectsManager.markDebugData(25, particleSupplier);
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        ParticleCaptures.setParticle(particleEffect);
        Particle apply = function.apply(particleEffect);
        ParticleCaptures.setParticle(null);
        return apply;
    }

    public static Particle swapParticle(Level world, ParticleOptions original, Function<ParticleOptions, Particle> function, Supplier<Particle> originalCall, double x, double y, double z) {
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return ParticleEffectsManager.markDebugData(10, originalCall);
        }
        if (ParticleCaptures.getParticle() != original) {
            return ParticleEffectsManager.markDebugData(11, originalCall);
        }
        boolean bl = original.equals(ParticleTypes.f_123811_);
        boolean bl2 = original.equals(ParticleTypes.f_123770_);
        if (!bl && !bl2) {
            return ParticleEffectsManager.markDebugData(12, originalCall);
        }
        int color = ArgbUtils.getArgb(bl2 ? 38 : 255, (int)(x * 255.0), (int)(y * 255.0), (int)(z * 255.0));
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return ParticleEffectsManager.markDebugData(14, originalCall);
        }
        if (list.isEmpty()) {
            return ParticleEffectsManager.markDebugData(15, originalCall);
        }
        if (world == null) {
            return ParticleEffectsManager.markDebugData(16, originalCall);
        }
        ParticleOptions particleEffect = ListUtils.getRandomElement(list, world.m_213780_());
        if (particleEffect == null) {
            return ParticleEffectsManager.markDebugData(17, originalCall);
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return function.apply(particleEffect);
    }

    private static Particle markDebugData(int data, Supplier<Particle> supplier) {
        ParticleCaptures.setDebugData(data);
        Particle particle = supplier.get();
        ParticleCaptures.setDebugData(null);
        return particle;
    }
}

