/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParseException;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.client.sound.CartingJukeboxSound;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.SupplyCartContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public final class SupplyCartEntity
extends AbstractDrawnInventoryEntity
implements Container {
    private static final ImmutableList<EntityDataAccessor<ItemStack>> CARGO = ImmutableList.of((Object)SynchedEntityData.m_135353_(SupplyCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(SupplyCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(SupplyCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_), (Object)SynchedEntityData.m_135353_(SupplyCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_));

    public SupplyCartEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
    }

    @Override
    protected AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.get().supplyCart;
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new CartItemStackHandler<SupplyCartEntity>(54, this){

            protected void onLoad() {
                super.onLoad();
                this.onContentsChanged(0);
            }

            protected void onContentsChanged(int slot) {
                Object2IntLinkedOpenHashMap totals = new Object2IntLinkedOpenHashMap();
                Object2ObjectOpenHashMap stacks = new Object2ObjectOpenHashMap();
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack stack = this.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    totals.mergeInt((Object)stack.m_41720_(), 1, Integer::sum);
                    stacks.putIfAbsent((Object)stack.m_41720_(), (Object)stack);
                }
                Iterator topTotals = totals.object2IntEntrySet().stream().sorted(Comparator.comparingInt(e -> e.getKey() instanceof BlockItem ? 0 : 1).thenComparingInt(e -> -e.getIntValue())).limit(CARGO.size()).iterator();
                Object[] items = new ItemStack[CARGO.size()];
                Arrays.fill(items, ItemStack.f_41583_);
                int forth = this.getSlots() / CARGO.size();
                int pos = 0;
                while (topTotals.hasNext() && pos < CARGO.size()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)topTotals.next();
                    int count = Math.max(1, (entry.getIntValue() + forth / 2) / forth);
                    for (int n = 1; n <= count && pos < CARGO.size(); ++n) {
                        ItemStack stack = ((ItemStack)stacks.getOrDefault(entry.getKey(), (Object)ItemStack.f_41583_)).m_41777_();
                        stack.m_41764_(Math.min(stack.m_41741_(), entry.getIntValue() / n));
                        items[pos++] = stack;
                    }
                }
                for (int i = 0; i < CARGO.size(); ++i) {
                    ((SupplyCartEntity)this.cart).m_20088_().m_135381_((EntityDataAccessor)CARGO.get(i), items[i]);
                }
            }
        };
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            this.openContainer(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult bannerResult = this.useBanner(player, hand);
        if (bannerResult.m_19077_()) {
            return bannerResult;
        }
        ItemStack held = player.m_21120_(hand);
        if (this.hasJukebox()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (held.m_41720_() instanceof RecordItem && this.insertDisc(player, held) || this.ejectDisc(player)) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        if (this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean insertDisc(Player player, ItemStack held) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!DiscTag.insert(stack, held)) continue;
            this.inventory.setStackInSlot(i, stack);
            this.m_20194_().m_129783_().m_6018_().m_7726_().m_8394_((Entity)this, (Packet)new ClientboundSetEntityDataPacket(this.m_19879_(), this.f_19804_.m_135378_()));
            this.m_9236_().m_7605_((Entity)this, (byte)5);
            if (!player.m_150110_().f_35937_) {
                held.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private boolean ejectDisc(Player player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            DiscTag record = DiscTag.get(stack);
            if (!record.eject(player)) continue;
            this.inventory.setStackInSlot(i, stack);
            return true;
        }
        return false;
    }

    public boolean hasJukebox() {
        for (EntityDataAccessor slot : CARGO) {
            ItemStack cargo = (ItemStack)this.f_19804_.m_135370_(slot);
            if (cargo.m_41720_() != Items.f_41984_) continue;
            return true;
        }
        return false;
    }

    public ItemStack getDisc() {
        for (EntityDataAccessor slot : CARGO) {
            ItemStack disc = DiscTag.get((ItemStack)((ItemStack)this.f_19804_.m_135370_((EntityDataAccessor)slot))).disc;
            if (disc.m_41619_()) continue;
            return disc;
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 5) {
            for (EntityDataAccessor slot : CARGO) {
                ItemStack disc = DiscTag.get((ItemStack)((ItemStack)this.f_19804_.m_135370_((EntityDataAccessor)slot))).disc;
                if (disc.m_41619_()) continue;
                CartingJukeboxSound.play(this, disc);
                break;
            }
        } else {
            super.m_7822_(id);
        }
    }

    public double m_6048_() {
        return 0.6875;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction pCallback) {
        if (this.m_20363_(passenger)) {
            Vec3 forward = this.m_20154_();
            Vec3 origin = new Vec3(0.0, this.m_6048_(), 0.0625);
            Vec3 pos = origin.m_82549_(forward.m_82490_(-0.68));
            passenger.m_6034_(this.m_20185_() + pos.f_82479_, this.m_20186_() + pos.f_82480_ - 0.1 + passenger.m_6049_(), this.m_20189_() + pos.f_82481_);
            passenger.m_5618_(this.m_146908_() + 180.0f);
            float f2 = Mth.m_14177_((float)(passenger.m_146908_() - this.m_146908_() + 180.0f));
            float f1 = Mth.m_14036_((float)f2, (float)-105.0f, (float)105.0f);
            passenger.f_19859_ += f1 - f2;
            passenger.m_146922_(passenger.m_146908_() + (f1 - f2));
            passenger.m_5616_(passenger.m_146908_());
        }
    }

    public NonNullList<ItemStack> getCargo() {
        NonNullList cargo = NonNullList.m_122780_((int)CARGO.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < CARGO.size(); ++i) {
            cargo.set(i, (Object)((ItemStack)this.f_19804_.m_135370_((EntityDataAccessor)CARGO.get(i))));
        }
        return cargo;
    }

    @Override
    public Item getCartItem() {
        return (Item)AstikorCarts.Items.SUPPLY_CART.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        for (EntityDataAccessor parameter : CARGO) {
            this.f_19804_.m_135372_(parameter, (Object)ItemStack.f_41583_);
        }
    }

    public void openContainer(Player player) {
        if (!this.m_9236_().f_46443_) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, plyr) -> new SupplyCartContainer(id, inv, (AbstractDrawnInventoryEntity)this), this.m_5446_()));
        }
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        return this.inventory.extractItem(slot, amount, false);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.inventory.extractItem(slot, 64, true);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.m_8016_(i);
        }
    }

    static class DiscTag {
        static final DiscTag EMPTY = new DiscTag(ItemStack.f_41583_, new CompoundTag(), new CompoundTag(), ItemStack.f_41583_);
        final ItemStack stack;
        final CompoundTag nbt;
        final CompoundTag tag;
        final ItemStack disc;

        DiscTag(ItemStack stack, CompoundTag nbt, CompoundTag tag, ItemStack disc) {
            this.stack = stack;
            this.nbt = nbt;
            this.tag = tag;
            this.disc = disc;
        }

        boolean isEmpty() {
            return this.stack.m_41619_();
        }

        boolean eject(Player player) {
            CompoundTag display;
            if (this.isEmpty()) {
                return false;
            }
            this.tag.m_128473_("RecordItem");
            if (this.tag.m_128456_()) {
                this.nbt.m_128473_("BlockEntityTag");
            }
            if (this.nbt.m_128425_("display", 10) && (display = this.nbt.m_128469_("display")).m_128425_("Lore", 9)) {
                ListTag lore = display.m_128437_("Lore", 8);
                String descKey = this.disc.m_41720_().m_5524_() + ".desc";
                int i = lore.size();
                while (i-- > 0) {
                    TranslatableContents translatable;
                    MutableComponent component;
                    String s = lore.m_128778_(i);
                    try {
                        component = Component.Serializer.m_130701_((String)s);
                    }
                    catch (JsonParseException ignored) {
                        continue;
                    }
                    ComponentContents componentContents = component.m_214077_();
                    if (!(componentContents instanceof TranslatableContents) || !descKey.equals((translatable = (TranslatableContents)componentContents).m_237508_())) continue;
                    lore.remove(i);
                }
            }
            if (this.nbt.m_128456_()) {
                this.stack.m_41751_(null);
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.disc, (int)player.m_150109_().f_35977_);
            return true;
        }

        static DiscTag get(ItemStack stack) {
            if (stack.m_41720_() != Items.f_41984_) {
                return EMPTY;
            }
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null || !nbt.m_128425_("BlockEntityTag", 10)) {
                return EMPTY;
            }
            CompoundTag tag = nbt.m_128469_("BlockEntityTag");
            if (!tag.m_128425_("RecordItem", 10)) {
                return EMPTY;
            }
            return new DiscTag(stack, nbt, tag, ItemStack.m_41712_((CompoundTag)tag.m_128469_("RecordItem")));
        }

        static boolean insert(ItemStack stack, ItemStack disc) {
            if (stack.m_41720_() != Items.f_41984_) {
                return false;
            }
            CompoundTag tag = stack.m_41698_("BlockEntityTag");
            if (tag.m_128425_("RecordItem", 10)) {
                return false;
            }
            tag.m_128365_("RecordItem", (Tag)disc.m_41739_(new CompoundTag()));
            CompoundTag display = stack.m_41698_("display");
            ListTag lore = display.m_128437_("Lore", 8);
            lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237115_((String)(disc.m_41778_() + ".desc")))));
            display.m_128365_("Lore", (Tag)lore);
            return true;
        }
    }
}

