/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events;

import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.IEntityEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class OnLootGenerated
implements IEntityEvent {
    public final ObjectArrayList<ItemStack> generatedLoot;
    public final ResourceLocation lootId;
    public final LootContext context;
    public final ServerLevel level;
    @Nullable
    public final BlockState blockState;
    @Nullable
    public final DamageSource damageSource;
    @Nullable
    public final Entity killer;
    @Nullable
    public final Entity entity;
    @Nullable
    public final Player lastDamagePlayer;
    @Nullable
    public final ItemStack tool;
    @Nullable
    public final Vec3 origin;

    public static Event<OnLootGenerated> listen(Consumer<OnLootGenerated> consumer) {
        return Events.get(OnLootGenerated.class).add(consumer);
    }

    public OnLootGenerated(ObjectArrayList<ItemStack> generatedLoot, @Nullable ResourceLocation lootId, LootContext context) {
        this.generatedLoot = generatedLoot;
        this.lootId = lootId != null ? lootId : new ResourceLocation("empty");
        this.context = context;
        this.level = context.m_78952_();
        this.blockState = (BlockState)this.getParameter(LootContextParams.f_81461_);
        this.damageSource = (DamageSource)this.getParameter(LootContextParams.f_81457_);
        this.killer = (Entity)this.getParameter(LootContextParams.f_81458_);
        this.entity = (Entity)this.getParameter(LootContextParams.f_81455_);
        this.lastDamagePlayer = (Player)this.getParameter(LootContextParams.f_81456_);
        this.tool = (ItemStack)this.getParameter(LootContextParams.f_81463_);
        this.origin = (Vec3)this.getParameter(LootContextParams.f_81460_);
    }

    @Override
    public Entity getEntity() {
        return this.entity != null ? this.entity : this.killer;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Vec3 getPosition() {
        return this.origin != null ? this.origin : new Vec3(0.0, 0.0, 0.0);
    }

    private <Type> Type getParameter(LootContextParam<Type> parameter) {
        return (Type)this.context.m_78953_(parameter);
    }
}

