/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public abstract class CustomParticle
extends TextureSheetParticle {
    public IFormula<Double> xdFormula = xd -> xd * (this.f_107218_ ? 0.5 : 0.95);
    public IFormula<Double> ydFormula = yd -> yd - (this.f_107218_ ? 0.0 : 0.0375);
    public IFormula<Double> zdFormula = zd -> zd * (this.f_107218_ ? 0.5 : 0.95);
    public IFormula<Float> alphaFormula = alpha -> alpha;
    public IFormula<Float> scaleFormula = lifeRatio -> Float.valueOf(1.0f - 0.5f * lifeRatio.floatValue());

    public CustomParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ = this.xdFormula.apply(this.f_107215_);
            this.f_107216_ = this.ydFormula.apply(this.f_107216_);
            this.f_107217_ = this.zdFormula.apply(this.f_107217_);
            this.f_107230_ = this.alphaFormula.apply(Float.valueOf(this.f_107230_)).floatValue();
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        Quaternionf quaternion;
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = this.getY((float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_()));
        float z = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            quaternion.rotateZ(Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_));
        }
        quaternion = this.getQuaternion(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.m_5902_(partialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(size);
            vector3f.add(x, y, z);
        }
        float f6 = this.m_5970_();
        float f7 = this.m_5952_();
        float f4 = this.m_5951_();
        float f5 = this.m_5950_();
        int light = this.m_6355_(partialTick);
        consumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        consumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f7, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        consumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f6, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        consumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f6, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * this.scaleFormula.apply(Float.valueOf(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_)).floatValue();
    }

    public float getY(float y) {
        return y;
    }

    public Quaternionf getQuaternion(Quaternionf quaternion) {
        return quaternion;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface IFormula<Type> {
        public Type apply(Type var1);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface IModification<ParticleType extends Particle, OptionsType extends ParticleOptions> {
        public void apply(ParticleType var1, OptionsType var2);
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface IFactory<Type extends Particle> {
        public Type create(ClientLevel var1, double var2, double var4, double var6, double var8, double var10, double var12, SpriteSet var14);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SimpleFactory
    extends Factory<Particle, SimpleParticleType> {
        public SimpleFactory(SpriteSet sprite, IFactory<Particle> factory) {
            super(sprite, factory);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory<ParticleType extends Particle, OptionsType extends ParticleOptions>
    implements ParticleProvider<OptionsType> {
        private final SpriteSet spriteSet;
        private final IFactory<ParticleType> factory;
        private final IModification<ParticleType, OptionsType> function;

        public Factory(SpriteSet sprite, IFactory<ParticleType> factory, IModification<ParticleType, OptionsType> function) {
            this.spriteSet = sprite;
            this.factory = factory;
            this.function = function;
        }

        public Factory(SpriteSet sprite, IFactory<ParticleType> factory) {
            this(sprite, factory, (particle, options) -> {});
        }

        public Particle m_6966_(OptionsType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleType particle = this.factory.create(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            this.function.apply(particle, type);
            return particle;
        }
    }
}

