/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.IPlayerInputCallback;
import com.github.exopandora.shouldersurfing.api.model.Perspective;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.math.Vec2f;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class InputHandler {
    public static final KeyMapping CAMERA_LEFT = InputHandler.createKeyMapping("adjust_camera_left", 263);
    public static final KeyMapping CAMERA_RIGHT = InputHandler.createKeyMapping("adjust_camera_right", 262);
    public static final KeyMapping CAMERA_IN = InputHandler.createKeyMapping("adjust_camera_in", 265);
    public static final KeyMapping CAMERA_OUT = InputHandler.createKeyMapping("adjust_camera_out", 264);
    public static final KeyMapping CAMERA_UP = InputHandler.createKeyMapping("adjust_camera_up", 266);
    public static final KeyMapping CAMERA_DOWN = InputHandler.createKeyMapping("adjust_camera_down", 267);
    public static final KeyMapping SWAP_SHOULDER = InputHandler.createKeyMapping("swap_shoulder", 79);
    public static final KeyMapping TOGGLE_FIRST_PERSON = InputHandler.createKeyMapping("toggle_first_person", InputConstants.f_84822_.m_84873_());
    public static final KeyMapping TOGGLE_THIRD_PERSON_FRONT = InputHandler.createKeyMapping("toggle_third_person_front", InputConstants.f_84822_.m_84873_());
    public static final KeyMapping TOGGLE_THIRD_PERSON_BACK = InputHandler.createKeyMapping("toggle_third_person_back", InputConstants.f_84822_.m_84873_());
    public static final KeyMapping FREE_LOOK = InputHandler.createKeyMapping("free_look", 342);
    public static final KeyMapping TOGGLE_CAMERA_COUPLING = InputHandler.createKeyMapping("toggle_camera_coupling", InputConstants.f_84822_.m_84873_());
    public static final KeyMapping TOGGLE_X_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_x_offset_presets", InputConstants.f_84822_.m_84873_());
    public static final KeyMapping TOGGLE_Y_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_y_offset_presets", InputConstants.f_84822_.m_84873_());
    public static final KeyMapping TOGGLE_Z_OFFSET_PRESETS = InputHandler.createKeyMapping("toggle_z_offset_presets", InputConstants.f_84822_.m_84873_());
    private final ShoulderSurfingImpl instance;

    public InputHandler(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public void tick() {
        Options options = Minecraft.m_91087_().f_91066_;
        while (TOGGLE_FIRST_PERSON.m_90859_()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.FIRST_PERSON);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (TOGGLE_THIRD_PERSON_FRONT.m_90859_()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.THIRD_PERSON_FRONT);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (TOGGLE_THIRD_PERSON_BACK.m_90859_()) {
            if (this.instance.isShoulderSurfing()) {
                this.instance.changePerspective(Perspective.THIRD_PERSON_BACK);
                continue;
            }
            this.instance.changePerspective(Perspective.SHOULDER_SURFING);
        }
        while (CAMERA_LEFT.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraLeft();
        }
        while (CAMERA_RIGHT.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraRight();
        }
        while (CAMERA_OUT.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraOut();
        }
        while (CAMERA_IN.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraIn();
        }
        while (CAMERA_UP.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraUp();
        }
        while (CAMERA_DOWN.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            Config.CLIENT.adjustCameraDown();
        }
        while (SWAP_SHOULDER.m_90859_()) {
            if (!this.instance.isShoulderSurfing()) continue;
            this.instance.swapShoulder();
        }
        while (options.f_92103_.m_90859_()) {
            this.instance.togglePerspective();
        }
        while (FREE_LOOK.m_90859_()) {
        }
        while (TOGGLE_CAMERA_COUPLING.m_90859_()) {
            this.instance.toggleCameraCoupling();
        }
        while (TOGGLE_X_OFFSET_PRESETS.m_90859_()) {
            this.instance.toggleOffsetXPreset();
        }
        while (TOGGLE_Y_OFFSET_PRESETS.m_90859_()) {
            this.instance.toggleOffsetYPreset();
        }
        while (TOGGLE_Z_OFFSET_PRESETS.m_90859_()) {
            this.instance.toggleOffsetZPreset();
        }
    }

    public void updateMovementInput(Input input) {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity cameraEntity = minecraft.m_91288_();
        for (IPlayerInputCallback callback : ShoulderSurfingRegistrar.getInstance().getPlayerInputCallbacks()) {
            if (!callback.isForcingVanillaMovementInput(new IPlayerInputCallback.IsForcingVanillaMovementInputContext(minecraft, cameraEntity))) continue;
            return;
        }
        Vec2f moveVector = new Vec2f(input.f_108566_, input.f_108567_);
        if (this.instance.isShoulderSurfing() && this.instance.isFreeLooking()) {
            moveVector.rotateDegrees(Mth.m_14118_((float)cameraEntity.m_146908_(), (float)this.instance.getCamera().getFreeLookYRot()));
            input.f_108566_ = moveVector.x();
            input.f_108567_ = moveVector.y();
        } else if (this.instance.isShoulderSurfing() && minecraft.f_91074_ != null && cameraEntity == minecraft.f_91074_) {
            if (moveVector.lengthSquared() > 0.0) {
                ShoulderSurfingCamera camera = this.instance.getCamera();
                LocalPlayer player = minecraft.f_91074_;
                float yRot = player.m_146908_();
                if (this.instance.isEntityRotationDecoupled((LivingEntity)player, minecraft)) {
                    float cameraXRot = camera.getXRot();
                    float cameraYRot = camera.getYRot();
                    Vec2f rotated = moveVector.rotateDegrees(cameraYRot);
                    float xRot = cameraXRot * 0.5f;
                    float xRotO = player.m_146909_();
                    float yRotO = yRot;
                    yRot = (float)Mth.m_14175_((double)(Math.atan2(-rotated.x(), rotated.y()) * 57.2957763671875));
                    xRot = xRotO + Mth.m_14118_((float)xRotO, (float)xRot) * 0.25f;
                    yRot = yRotO + Mth.m_14118_((float)yRotO, (float)yRot) * 0.25f;
                    player.m_146926_(xRot);
                    player.m_146922_(yRot);
                }
                moveVector = moveVector.rotateDegrees(Mth.m_14118_((float)yRot, (float)camera.getYRot()));
            }
            input.f_108566_ = moveVector.x();
            input.f_108567_ = moveVector.y();
        }
    }

    @NotNull
    private static KeyMapping createKeyMapping(String key, int keyCode) {
        return new KeyMapping("key.shouldersurfing." + key, keyCode, "Shoulder Surfing");
    }
}

