/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GumWormRidingGoal
extends Goal {
    private final GumWormEntity entity;
    private float leapRot;

    public GumWormRidingGoal(GumWormEntity worm) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = worm;
    }

    public boolean m_8036_() {
        return this.entity.isRidingMode();
    }

    public void m_8041_() {
        this.entity.setLeaping(false);
        this.entity.setRidingLeapTime(0);
        this.entity.setBiting(false);
    }

    public void m_8037_() {
        Player ridingPlayer = this.entity.getRidingPlayer();
        if (ridingPlayer != null) {
            this.entity.m_21573_().m_26573_();
            if (this.entity.getRidingLeapTime() > 0 && this.entity.isValidRider()) {
                float f = Math.max(1.0f, (float)this.entity.getMaxRidingLeapTime());
                this.entity.setLeaping(true);
                float f1 = 1.0f - (float)this.entity.getRidingLeapTime() / f;
                Vec3 leapDelta = new Vec3(0.0, Math.sin((double)f1 * Math.PI * 1.5) * 2.0, 2.0).m_82524_((float)(-Math.toRadians(this.leapRot)));
                this.entity.m_20256_(leapDelta);
                this.entity.m_146922_(this.leapRot);
                this.entity.setRidingLeapTime(this.entity.getRidingLeapTime() - 1);
            } else {
                this.entity.setLeaping(false);
                Vec3 forwardsVec = new Vec3(this.entity.isValidRider() ? (double)(ridingPlayer.f_20900_ * 2.5f) : 0.0, 0.0, 10.0).m_82524_((float)(-Math.toRadians(this.entity.f_20883_))).m_82549_(this.entity.m_20182_());
                this.entity.m_21566_().m_6849_(forwardsVec.f_82479_, forwardsVec.f_82480_, forwardsVec.f_82481_, 3.0);
                this.entity.setTargetDigPitch(this.entity.f_19862_ ? -45.0f : 0.0f);
                this.leapRot = this.entity.m_146908_();
            }
            if (this.entity.isMouthOpen()) {
                this.entity.attackAllAroundMouth((float)this.entity.m_21051_(Attributes.f_22281_).m_22135_(), 2.0f);
            }
            if (this.entity.isMouthForcedOpen()) {
                this.entity.setBiting(true);
            } else {
                this.entity.setBiting(false);
            }
        }
    }
}

