/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ThinBoneBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty OFFSET = IntegerProperty.m_61631_((String)"offset", (int)0, (int)2);
    public final Map<BlockState, VoxelShape> shapeMap = new HashMap<BlockState, VoxelShape>();
    public static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_Y = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_Z = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);

    public ThinBoneBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283761_).m_60999_().m_60978_(2.0f).m_60918_(SoundType.f_56724_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OFFSET, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y));
    }

    protected VoxelShape getThinBoneShape(BlockState state) {
        if (this.shapeMap.containsKey(state)) {
            return this.shapeMap.get(state);
        }
        VoxelShape merge = switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            case Direction.Axis.Z -> SHAPE_Z;
            default -> SHAPE_Z;
        };
        if (state.m_61143_((Property)f_55923_) == Direction.Axis.Y || (Integer)state.m_61143_((Property)OFFSET) == 1) {
            boolean offset = false;
        } else {
            int offset = (Integer)state.m_61143_((Property)OFFSET) == 0 ? -6 : 6;
            merge = merge.m_83216_(0.0, (double)((float)offset / 16.0f), 0.0);
        }
        this.shapeMap.put(state, merge);
        return merge;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getThinBoneShape(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        int offset = 0;
        if (context.m_43719_().m_122434_().m_122479_()) {
            Vec3 vec3 = context.m_43720_().m_82546_(Vec3.m_82528_((Vec3i)context.m_8083_()));
            offset = vec3.f_82480_ < (double)0.33f ? 0 : (vec3.f_82480_ < (double)0.66f ? 1 : 2);
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_55923_, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)OFFSET, (Comparable)Integer.valueOf(offset));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{WATERLOGGED, f_55923_, OFFSET});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }
}

