/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MothBallBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape ONE_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    private static final VoxelShape MULTI_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    public static final IntegerProperty BALLS = IntegerProperty.m_61631_((String)"balls", (int)1, (int)5);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public MothBallBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60910_().m_60978_(0.5f).m_60918_(ACSoundTypes.MOTH_BALL));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BALLS, (Comparable)Integer.valueOf(1)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        return belowState.m_60659_((BlockGetter)level, pos.m_7495_(), Direction.UP, SupportType.FULL);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)BALLS) > 1 ? MULTI_SHAPE : ONE_SHAPE;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)BALLS) < 5 || super.m_6864_(state, useContext);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level levelaccessor = context.m_43725_();
        BlockState blockstate = levelaccessor.m_8055_(blockpos = context.m_8083_());
        return blockstate.m_60734_() == this ? (BlockState)blockstate.m_61124_((Property)BALLS, (Comparable)Integer.valueOf(Math.min(5, (Integer)blockstate.m_61143_((Property)BALLS) + 1))) : (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    protected void removeOneBall(Level worldIn, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)BALLS);
        if (i <= 1) {
            worldIn.m_46961_(pos, false);
        } else {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BALLS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        this.removeOneBall(worldIn, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BALLS, WATERLOGGED});
    }
}

