/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.misc;

import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.misc.CaveMapRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class CaveMapRenderHelper {
    public static void renderOneHandedCaveMap(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float animation1, HumanoidArm arm, float animation2, ItemStack caveMapItem) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float scale = 2.0f;
        poseStack.m_252880_(f * 0.125f, -0.125f, 0.0f);
        if (!Minecraft.m_91087_().f_91074_.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 10.0f));
            poseStack.m_252880_(0.0f, 0.0f, 0.5f);
            poseStack.m_85841_(scale, scale, scale);
            CaveMapRenderHelper.renderPlayerArm(poseStack, bufferSource, packedLight, animation1, animation2, arm);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_252880_(f * 0.51f, -0.08f + animation1 * -1.2f, -0.75f);
        float f1 = Mth.m_14116_((float)animation2);
        float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = 0.25f;
        float f4 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.m_14031_((float)(animation2 * (float)Math.PI));
        poseStack.m_252880_(f * f3, f4 - 0.3f * f2, f5);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f2 * -45.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * f2 * -30.0f));
        poseStack.m_85841_(scale, scale, scale);
        CaveMapRenderHelper.renderCaveMap(poseStack, bufferSource, packedLight, caveMapItem, false);
        poseStack.m_85849_();
    }

    public static void renderCaveMap(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, ItemStack caveMapItem, boolean showBackground) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85841_(0.38f, 0.38f, 0.38f);
        poseStack.m_252880_(-0.5f, -0.5f, 0.0f);
        poseStack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(ACRenderTypes.getCaveMapBackground(CaveMapRenderer.MAP_BACKGROUND, showBackground));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertexconsumer.m_252986_(matrix4f, -7.0f, 135.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 135.0f, 135.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 135.0f, -7.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        vertexconsumer.m_252986_(matrix4f, -7.0f, -7.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        CaveMapRenderer.getMapFor(caveMapItem, true).render(poseStack, multiBufferSource, caveMapItem, false, light);
    }

    public static void renderTwoHandedCaveMap(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float partialTick, float animation1, float animation2, ItemStack caveMapItem) {
        float f = Mth.m_14116_((float)animation2);
        float f1 = -0.2f * Mth.m_14031_((float)(animation2 * (float)Math.PI));
        float f2 = -0.4f * Mth.m_14031_((float)(f * (float)Math.PI));
        float xRot = Mth.m_14179_((float)partialTick, (float)Minecraft.m_91087_().f_91074_.f_19860_, (float)Minecraft.m_91087_().f_91074_.m_146909_());
        poseStack.m_252880_(0.0f, -f1 / 2.0f, f2);
        float f3 = CaveMapRenderHelper.calculateMapTilt(xRot);
        poseStack.m_252880_(0.0f, 0.04f + animation1 * -1.2f + f3 * -0.5f, -0.72f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f3 * -85.0f));
        if (!Minecraft.m_91087_().f_91074_.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            CaveMapRenderHelper.renderMapHand(poseStack, multiBufferSource, packedLight, HumanoidArm.RIGHT);
            CaveMapRenderHelper.renderMapHand(poseStack, multiBufferSource, packedLight, HumanoidArm.LEFT);
            poseStack.m_85849_();
        }
        float f4 = Mth.m_14031_((float)(f * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f4 * 20.0f));
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        CaveMapRenderHelper.renderCaveMap(poseStack, multiBufferSource, packedLight, caveMapItem, false);
    }

    private static void renderMapHand(PoseStack poseStack, MultiBufferSource bufferSource, int i, HumanoidArm humanoidArm) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Minecraft.m_91087_().f_91074_.m_108560_());
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)Minecraft.m_91087_().f_91074_);
        poseStack.m_85836_();
        float f = humanoidArm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(92.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(f * -41.0f));
        poseStack.m_252880_(f * 0.3f, -1.1f, 0.45f);
        if (humanoidArm == HumanoidArm.RIGHT) {
            playerrenderer.m_117770_(poseStack, bufferSource, i, (AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
        } else {
            playerrenderer.m_117813_(poseStack, bufferSource, i, (AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
        }
        poseStack.m_85849_();
    }

    private static void renderPlayerArm(PoseStack poseStack, MultiBufferSource bufferSource, int i, float animation1, float animation2, HumanoidArm humanoidArm) {
        boolean flag = humanoidArm != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.m_14116_((float)animation2);
        float f2 = -0.3f * Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.m_14031_((float)(animation2 * (float)Math.PI));
        poseStack.m_252880_(f * (f2 + 0.64000005f), f3 + -0.6f + animation1 * -0.6f, f4 + -0.71999997f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 45.0f));
        float f5 = Mth.m_14031_((float)(animation2 * animation2 * (float)Math.PI));
        float f6 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * f6 * 70.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(f * f5 * -20.0f));
        LocalPlayer abstractclientplayer = Minecraft.m_91087_().f_91074_;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)abstractclientplayer.m_108560_());
        poseStack.m_252880_(f * -1.0f, 3.6f, 3.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 120.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f * -135.0f));
        poseStack.m_252880_(f * 5.6f, 0.0f, 0.0f);
        PlayerRenderer playerrenderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)abstractclientplayer);
        if (flag) {
            playerrenderer.m_117770_(poseStack, bufferSource, i, (AbstractClientPlayer)abstractclientplayer);
        } else {
            playerrenderer.m_117813_(poseStack, bufferSource, i, (AbstractClientPlayer)abstractclientplayer);
        }
    }

    private static float calculateMapTilt(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        return -Mth.m_14089_((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
    }
}

