/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.TeletorEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class TeletorModel
extends AdvancedEntityModel<TeletorEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox head;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rarmPivot;
    private final AdvancedModelBox larmPivot;
    private final AdvancedModelBox rlegcrossed;
    private final AdvancedModelBox llegcrossed;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox lleg;

    public TeletorModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body.setTextureOffset(40, 37).addBox(-3.0f, -16.0f, -2.0f, 6.0f, 6.0f, 4.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -16.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(0, 0).addBox(-6.0f, -18.0f, -6.0f, 12.0f, 17.0f, 12.0f, 0.0f, false);
        this.head.setTextureOffset(40, 29).addBox(6.0f, -9.0f, -2.0f, 9.0f, 4.0f, 4.0f, 0.0f, false);
        this.head.setTextureOffset(20, 29).addBox(9.0f, -23.0f, -2.0f, 6.0f, 14.0f, 4.0f, 0.0f, false);
        this.head.setTextureOffset(40, 29).addBox(-15.0f, -9.0f, -2.0f, 9.0f, 4.0f, 4.0f, 0.0f, true);
        this.head.setTextureOffset(0, 29).addBox(-15.0f, -23.0f, -2.0f, 6.0f, 14.0f, 4.0f, 0.0f, false);
        this.rarmPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarmPivot.setRotationPoint(-3.0f, -16.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.rarmPivot);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarmPivot.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(34, 8).addBox(-9.0f, 0.0f, -1.0f, 9.0f, 0.0f, 2.0f, 0.0f, true);
        this.larmPivot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larmPivot.setRotationPoint(3.0f, -16.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.larmPivot);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larmPivot.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(34, 8).addBox(0.0f, 0.0f, -1.0f, 9.0f, 0.0f, 2.0f, 0.0f, false);
        this.rlegcrossed = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rlegcrossed.setRotationPoint(-1.5f, -10.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.rlegcrossed);
        this.rlegcrossed.setTextureOffset(0, 47).addBox(-1.5f, 0.0f, -5.0f, 3.0f, 2.0f, 5.0f, 0.0f, true);
        this.llegcrossed = new AdvancedModelBox((AdvancedEntityModel)this);
        this.llegcrossed.setRotationPoint(1.5f, -9.0f, -3.0f);
        this.body.addChild((BasicModelPart)this.llegcrossed);
        this.llegcrossed.setTextureOffset(0, 47).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 5.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-2.0f, -10.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(4, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 0.0f, 0.0f, false);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(2.0f, -10.0f, 0.0f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(4, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 6.0f, 0.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.larm, (Object)this.lleg, (Object)this.llegcrossed, (Object)this.rarm, (Object)this.rleg, (Object)this.rlegcrossed, (Object)this.rarmPivot, (Object)this.larmPivot);
    }

    public void setupAnim(TeletorEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        if (entity.areLegsCrossed(limbSwingAmount)) {
            this.lleg.showModel = false;
            this.rleg.showModel = false;
            this.llegcrossed.showModel = true;
            this.rlegcrossed.showModel = true;
        } else {
            this.lleg.showModel = true;
            this.rleg.showModel = true;
            this.llegcrossed.showModel = false;
            this.rlegcrossed.showModel = false;
        }
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float controlProgress = entity.getControlProgress(partialTick);
        this.progressRotationPrev(this.body, limbSwingAmount, (float)Math.toRadians(20.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, limbSwingAmount, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.head, controlProgress * limbSwingAmount, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, limbSwingAmount, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, limbSwingAmount, (float)Math.toRadians(40.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, limbSwingAmount, (float)Math.toRadians(40.0), (float)Math.toRadians(40.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.larm, limbSwingAmount, (float)Math.toRadians(40.0), (float)Math.toRadians(-40.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, controlProgress * limbSwingAmount, (float)Math.toRadians(-60.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(60.0), 1.0f);
        this.progressRotationPrev(this.larm, controlProgress * limbSwingAmount, (float)Math.toRadians(-60.0), (float)Math.toRadians(40.0), (float)Math.toRadians(-60.0), 1.0f);
        this.progressPositionPrev(this.body, limbSwingAmount, 0.0f, 1.0f, 2.0f, 1.0f);
        this.progressPositionPrev(this.head, limbSwingAmount, 0.0f, -1.0f, -2.0f, 1.0f);
        this.progressPositionPrev(this.rarm, limbSwingAmount, -1.0f, 1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.larm, limbSwingAmount, 1.0f, 1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rarm, controlProgress, -1.0f, 1.0f, -2.0f, 1.0f);
        this.progressPositionPrev(this.larm, controlProgress, 1.0f, 1.0f, -2.0f, 1.0f);
        this.progressRotationPrev(this.rarm, controlProgress, (float)Math.toRadians(-10.0), (float)Math.toRadians(-90.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.larm, controlProgress, (float)Math.toRadians(-10.0), (float)Math.toRadians(90.0), 0.0f, 1.0f);
        this.bob(this.body, 0.1f, 2.0f, false, ageInTicks, 1.0f);
        this.bob(this.head, 0.1f, 1.0f, false, ageInTicks, 1.0f);
        this.flap(this.larm, 0.1f, 0.2f, true, -1.0f, -0.4f, ageInTicks, 1.0f);
        this.flap(this.rarm, 0.1f, 0.2f, false, -1.0f, -0.4f, ageInTicks, 1.0f);
        this.swing(this.llegcrossed, 0.1f, 0.2f, false, -2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.rlegcrossed, 0.1f, 0.2f, true, -2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.rarm, 0.5f, 0.2f, false, 2.0f, 0.0f, ageInTicks, controlProgress);
        this.swing(this.larm, 0.5f, 0.2f, true, 2.0f, 0.0f, ageInTicks, controlProgress);
        this.rarm.rotationPointZ -= (float)(Math.sin(ageInTicks * 0.5f) * (double)controlProgress);
        this.rarm.rotationPointX -= (float)(Math.sin(ageInTicks * 0.5f + 2.0f) * (double)controlProgress * 0.5);
        this.larm.rotationPointZ -= (float)(Math.sin(ageInTicks * 0.5f) * (double)controlProgress);
        this.larm.rotationPointX += (float)(Math.sin(ageInTicks * 0.5f + 2.0f) * (double)controlProgress * 0.5);
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
        Entity look = entity.getWeapon();
        if (look != null) {
            Vec3 vector3d = look.m_20299_(partialTick);
            Vec3 vector3d1 = entity.m_20299_(partialTick);
            double d0 = Mth.m_14008_((double)((vector3d.f_82480_ - vector3d1.f_82480_) * 0.5), (double)-1.0, (double)1.0) * Math.PI / 2.0;
            Vec3 vector3d2 = entity.m_20252_(0.0f);
            vector3d2 = new Vec3(vector3d2.f_82479_, 0.0, vector3d2.f_82481_);
            Vec3 vector3d3 = new Vec3(vector3d.f_82479_ - vector3d1.f_82479_, 0.0, vector3d.f_82481_ - vector3d1.f_82481_).m_82541_().m_82524_(1.5707964f);
            double d1 = vector3d2.m_82526_(vector3d3);
            this.rarmPivot.rotateAngleX = (float)((double)this.rarmPivot.rotateAngleX - d0 * (double)controlProgress);
            this.larmPivot.rotateAngleX = (float)((double)this.larmPivot.rotateAngleX - d0 * (double)controlProgress);
            this.rarmPivot.rotateAngleY = (float)((double)this.rarmPivot.rotateAngleY + d1 * (double)controlProgress);
            this.larmPivot.rotateAngleY = (float)((double)this.larmPivot.rotateAngleY + d1 * (double)controlProgress);
            if (d0 > 0.0) {
                this.head.rotationPointY = (float)((double)this.head.rotationPointY - d0 * (double)controlProgress * 5.0);
            }
        }
    }

    public Vec3 translateToHead(Vec3 in, float yawIn) {
        PoseStack modelTranslateStack = new PoseStack();
        modelTranslateStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yawIn));
        modelTranslateStack.m_85837_((double)(this.body.rotationPointX / 16.0f), (double)(this.body.rotationPointY / 16.0f), (double)(this.body.rotationPointZ / 16.0f));
        modelTranslateStack.m_252781_(Axis.f_252393_.m_252961_(this.body.rotateAngleZ));
        modelTranslateStack.m_252781_(Axis.f_252392_.m_252961_(this.body.rotateAngleY));
        modelTranslateStack.m_252781_(Axis.f_252495_.m_252961_(this.body.rotateAngleX));
        modelTranslateStack.m_85837_((double)(this.head.rotationPointX / 16.0f), (double)(this.head.rotationPointY / 16.0f), (double)(this.head.rotationPointZ / 16.0f));
        modelTranslateStack.m_252781_(Axis.f_252393_.m_252961_(this.head.rotateAngleZ));
        modelTranslateStack.m_252781_(Axis.f_252392_.m_252961_(this.head.rotateAngleY));
        modelTranslateStack.m_252781_(Axis.f_252495_.m_252961_(this.head.rotateAngleX));
        Vector4f bodyOffsetVec = new Vector4f((float)in.f_82479_, (float)in.f_82480_, (float)in.f_82481_, 1.0f);
        bodyOffsetVec.mul((Matrix4fc)modelTranslateStack.m_85850_().m_252922_());
        Vec3 offset = new Vec3((double)bodyOffsetVec.x(), (double)bodyOffsetVec.y(), (double)bodyOffsetVec.z());
        modelTranslateStack.m_85849_();
        return offset;
    }
}

