/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.datafixers.util.Pair;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ItemListInventory;
import de.maxhenkel.corpse.corelib.inventory.LockedSlot;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.gui.ITransferrable;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CorpseInventoryContainer
extends CorpseContainerBase
implements ITransferrable {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private ItemListInventory mainInventory;
    private ItemListInventory armorInventory;
    private ItemListInventory offHandInventory;

    public CorpseInventoryContainer(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super((MenuType)Main.CONTAINER_TYPE_CORPSE_INVENTORY.get(), id, playerInventory, corpse, editable, history);
        int k;
        this.mainInventory = new ItemListInventory(corpse.getDeath().getMainInventory());
        this.armorInventory = new ItemListInventory(corpse.getDeath().getArmorInventory());
        this.offHandInventory = new ItemListInventory(corpse.getDeath().getOffHandInventory());
        for (int i = 0; i < 4; ++i) {
            final int slotIndex = 3 - i;
            this.m_38897_(new LockedSlot(this.armorInventory, slotIndex, 8 + i * 18, 18, true, !editable){

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[slotIndex]);
                }
            });
        }
        this.m_38897_(new LockedSlot(this.offHandInventory, 0, 98, 18, true, !editable){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new LockedSlot(this.mainInventory, j + k * 9 + 9, 8 + j * 18, 40 + k * 18, true, !editable));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.m_38897_(new LockedSlot(this.mainInventory, k, 8 + k * 18, 98, true, !editable));
        }
        this.addPlayerInventorySlots();
    }

    @Override
    public void transferItems() {
        if (!this.isEditable()) {
            return;
        }
        if (!(this.playerInventory.f_35978_ instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this.playerInventory.f_35978_;
        NonNullList additionalItems = NonNullList.m_122779_();
        this.fill((List<ItemStack>)additionalItems, this.mainInventory, (NonNullList<ItemStack>)this.playerInventory.f_35974_);
        this.fill((List<ItemStack>)additionalItems, this.armorInventory, (NonNullList<ItemStack>)this.playerInventory.f_35975_);
        this.fill((List<ItemStack>)additionalItems, this.offHandInventory, (NonNullList<ItemStack>)this.playerInventory.f_35976_);
        additionalItems.addAll(this.corpse.getDeath().getAdditionalItems());
        NonNullList restItems = NonNullList.m_122779_();
        for (ItemStack stack : additionalItems) {
            if (player.m_150109_().m_36054_(stack)) continue;
            restItems.add((Object)stack);
        }
        this.corpse.getDeath().getAdditionalItems().clear();
        this.corpse.getDeath().getAdditionalItems().addAll((Collection)restItems);
        if (!this.corpse.getDeath().getAdditionalItems().isEmpty()) {
            Guis.openAdditionalItems(player, this);
        }
    }

    private void fill(List<ItemStack> additionalItems, Container inventory, NonNullList<ItemStack> playerInv) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            ItemStack playerStack = (ItemStack)playerInv.get(i);
            if (!playerStack.m_41619_()) {
                additionalItems.add(playerStack);
            }
            inventory.m_6836_(i, ItemStack.f_41583_);
            playerInv.set(i, (Object)stack);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.corpse.isMainInventoryEmpty() && !this.corpse.isAdditionalInventoryEmpty() && this.playerInventory.f_35978_ instanceof ServerPlayer) {
            Guis.openAdditionalItems((ServerPlayer)this.playerInventory.f_35978_, this);
        }
    }

    @Override
    public int getInvOffset() {
        return 79;
    }

    @Override
    public int getInventorySize() {
        return 41;
    }
}

