/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.util.data.JSONHelper;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class TagRegistrationContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagRegistrationContext.class);
    private final Path file;
    private boolean changed;
    private final Map<ResourceLocation, Map<ResourceLocation, TagData>> storage = new HashMap<ResourceLocation, Map<ResourceLocation, TagData>>();
    protected final Runnable markChanged = this::markChanged;

    public TagRegistrationContext(Path file) {
        this.file = file;
    }

    private void markChanged() {
        this.changed = true;
    }

    protected TagData create(TagKey<?> tag) {
        return new TagData(tag, (Object2BooleanMap<String>)new Object2BooleanOpenHashMap(), this.markChanged);
    }

    protected Map<ResourceLocation, TagData> getTagMapForRegistry(ResourceLocation registry) {
        return this.storage.computeIfAbsent(registry, t -> new HashMap());
    }

    protected TagData getTagData(TagKey<?> tag) {
        return this.getTagMapForRegistry(tag.f_203867_().m_135782_()).computeIfAbsent(tag.f_203868_(), t -> this.create(tag));
    }

    public boolean addToTag(TagKey<?> tag, ResourceLocation item) {
        return this.getTagData(tag).enableItemInTag(item);
    }

    public static TagRegistrationContext load(String modid) {
        Path recipes = FMLPaths.CONFIGDIR.get().resolve("hammerlib").resolve("tags").resolve("modded").resolve(modid + ".json");
        TagRegistrationContext ctx = new TagRegistrationContext(recipes);
        try {
            Files.createDirectories(recipes.getParent(), new FileAttribute[0]);
            if (Files.isRegularFile(recipes, new LinkOption[0])) {
                new JSONTokener(Files.readString(recipes)).nextValueOBJ().ifPresent(obj -> {
                    JSONObject $ = obj.getJSONObject("tags");
                    for (String registry : $.keySet()) {
                        ResourceLocation regId = Resources.location(registry);
                        ResourceKey regKey = ResourceKey.m_135788_((ResourceLocation)regId);
                        JSONObject $$ = $.optJSONObject(registry);
                        if ($$ == null) continue;
                        for (String key : $$.keySet()) {
                            ResourceLocation tagId = Resources.location(key);
                            TagData td = ctx.getTagData(TagKey.m_203882_((ResourceKey)regKey, (ResourceLocation)tagId));
                            JSONObject $$$ = $$.optJSONObject(key);
                            if ($$$ == null) continue;
                            for (String itemId : $$$.keySet()) {
                                td.active.put((Object)itemId, $$$.optBoolean(itemId, true));
                            }
                        }
                    }
                });
            }
        }
        catch (IOException err) {
            log.error("Failed to load tag configs", (Throwable)err);
        }
        return ctx;
    }

    public void save() {
        if (this.changed) {
            JSONObject activeGlob = new JSONObject();
            JSONObject disabledGlob = new JSONObject();
            Function<String, JSONObject> activeByReg = type -> JSONHelper.computeObject(activeGlob, type);
            for (Map.Entry<ResourceLocation, Map<ResourceLocation, TagData>> entry : this.storage.entrySet()) {
                String registryKey = entry.getKey().toString();
                Supplier active = Suppliers.memoize(() -> (JSONObject)activeByReg.apply(registryKey));
                for (Map.Entry<ResourceLocation, TagData> tag : entry.getValue().entrySet()) {
                    String tagId = tag.getKey().toString();
                    TagData data = tag.getValue();
                    Supplier activeTag = Suppliers.memoize(() -> JSONHelper.computeObject((JSONObject)active.get(), tagId));
                    for (Object2BooleanMap.Entry st : data.active.object2BooleanEntrySet()) {
                        ((JSONObject)activeTag.get()).put((String)st.getKey(), st.getBooleanValue());
                    }
                }
            }
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                Files.writeString(this.file, (CharSequence)new JSONObject().put("version", 1).put("tags", activeGlob).put("unregistered", disabledGlob).toString(4), new OpenOption[0]);
            }
            catch (IOException e) {
                log.error("Failed to write tag configs", (Throwable)e);
            }
        }
    }

    protected record TagData(TagKey<?> type, Object2BooleanMap<String> active, Runnable changed) {
        public boolean enableItemInTag(ResourceLocation loc) {
            String id = loc.toString();
            if (!this.active.containsKey((Object)id)) {
                this.active.put((Object)id, true);
                this.changed.run();
            }
            return this.active.getBoolean((Object)id);
        }
    }
}

