/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.compat.jade;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;
import org.zeith.hammerlib.tiles.tooltip.ITooltipConsumer;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.impl.ui.ProgressElement;
import snownee.jade.impl.ui.ProgressStyle;

public class JadeTooltipConsumer
implements ITooltipConsumer {
    protected final ITooltip tooltip;
    protected final BlockAccessor accessor;

    public JadeTooltipConsumer(ITooltip tooltip, BlockAccessor accessor) {
        this.tooltip = tooltip;
        this.accessor = accessor;
    }

    @Override
    public Vec3 getHitVec() {
        return ((BlockHitResult)this.accessor.getHitResult()).m_82450_();
    }

    @Override
    public Direction getSideHit() {
        return this.accessor.getSide();
    }

    @Override
    public void addLine(Component text) {
        this.tooltip.add(text);
    }

    @Override
    public void addItem(ItemStack stack) {
        this.tooltip.add((IElement)ItemStackElement.of((ItemStack)stack));
    }

    @Override
    public void addBar(ProgressBar bar) {
        ProgressStyle style = new ProgressStyle();
        BoxStyle boxStyle = new BoxStyle();
        boxStyle.bgColor = bar.backgroundColor;
        boxStyle.borderColor = bar.borderColor;
        boxStyle.borderWidth = 1.0f;
        style.color = bar.filledMainColor;
        style.color2 = bar.filledAlternateColor;
        String core = switch (bar.numberFormat) {
            case EnumNumberFormat.COMPACT -> Math.round(bar.getProgress() * 100.0f) + " ";
            case EnumNumberFormat.NONE -> "";
            default -> Integer.toString(Math.round(bar.getProgress() * 100.0f));
        };
        String txt = (bar.prefix != null ? bar.prefix : "") + core + (bar.suffix != null ? bar.suffix : "");
        this.tooltip.add((IElement)new ProgressElement(bar.getProgress(), (Component)(txt.isBlank() ? null : Component.m_237113_((String)txt)), (IProgressStyle)style, (IBoxStyle)boxStyle, false));
    }
}

