/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.util.Tooltip;
import org.zeith.hammerlib.client.screen.IAdvancedComponent;

public class GuiItemObject
extends GuiObject
implements IAdvancedComponent {
    public Font font;
    public Supplier<ItemStack> stack;
    public boolean hoverable;
    public boolean decorated;
    public boolean provideIngredient;
    public int seed;
    public boolean isMouseOver;

    public GuiItemObject(String name, Supplier<ItemStack> stack) {
        super(name);
        this.font = Minecraft.m_91087_().f_91062_;
        this.decorated = true;
        this.seed = 0;
        this.size(16.0f, 16.0f);
        this.stack = stack;
    }

    public GuiItemObject seed(int seed) {
        this.seed = seed;
        return this;
    }

    public GuiItemObject hoverable(boolean hoverable) {
        this.hoverable = hoverable;
        return this;
    }

    public GuiItemObject decorated(boolean decorated) {
        this.decorated = decorated;
        return this;
    }

    public GuiItemObject provideIngredient(boolean provideIngredient) {
        this.provideIngredient = provideIngredient;
        return this;
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        ItemStack stack = this.stack.get();
        if (stack.m_41619_()) {
            return;
        }
        gfx.renderItem(stack, 0, 0, this.seed);
        if (this.decorated) {
            gfx.renderItemDecorations(this.font, stack, 0, 0);
        }
        this.isMouseOver = pos.isMouseWithin(this);
        if (this.hoverable && this.isMouseOver) {
            GuiGraphics g = gfx.gfx();
            AbstractContainerScreen.m_280359_((GuiGraphics)g, (int)0, (int)0, (int)0);
            this.drawTooltip(gfx, pos, this.font, Tooltip.ofItem(stack));
        }
    }

    @Override
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.provideIngredient && mouseX >= 0.0 && mouseY >= 0.0 && mouseX < (double)this.width && mouseY < (double)this.height) {
            return this.stack.get();
        }
        return null;
    }
}

