/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.opus;

import java.io.IOException;
import vminus.shadow.org.gagravarr.ogg.OggStreamAudioData;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioHeaders;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioStatistics;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioStream;
import vminus.shadow.org.gagravarr.opus.OpusAudioData;
import vminus.shadow.org.gagravarr.opus.OpusFile;
import vminus.shadow.org.gagravarr.opus.OpusInfo;

public class OpusStatistics
extends OggAudioStatistics {
    private int total_pages;
    private int total_packets;
    private int total_samples;
    private int max_packet_duration;
    private int min_packet_duration;
    private int max_page_duration;
    private int min_page_duration;
    private int max_packet_bytes;
    private int min_packet_bytes;
    private int sid;
    private long lastlastgranulepos = -1L;
    private long lastgranulepos = 0L;
    private long firstgranulepos = -1L;
    private int page_samples = 0;
    private int page_count = 0;
    private OpusInfo info;

    public OpusStatistics(OggAudioHeaders headers, OggAudioStream audio) throws IOException {
        super(headers, audio);
        if (!(headers.getInfo() instanceof OpusInfo)) {
            throw new IllegalArgumentException("Non-Opus stream " + headers.getInfo() + " supplied");
        }
        this.info = (OpusInfo)headers.getInfo();
        this.init(headers);
    }

    public OpusStatistics(OpusFile opus) throws IOException {
        super(opus, opus);
        this.info = opus.getInfo();
        this.init(opus);
    }

    private void init(OggAudioHeaders headers) throws IOException {
        this.sid = headers.getSid();
        this.max_packet_duration = 0;
        this.min_packet_duration = 5760;
        this.total_samples = 0;
        this.total_packets = 0;
        this.max_page_duration = -1;
        this.min_page_duration = 1468800;
        this.max_packet_bytes = 0;
        this.min_packet_bytes = Integer.MAX_VALUE;
    }

    public void calculate() throws IOException {
        super.calculate();
        if (this.max_page_duration < this.page_samples) {
            this.max_page_duration = this.page_samples;
        }
        if (this.min_page_duration > this.page_samples) {
            this.min_page_duration = this.page_samples;
        }
        this.total_pages = this.page_count;
    }

    protected void handleAudioData(OggStreamAudioData audioData) {
        this.handleAudioData((OpusAudioData)audioData);
    }

    protected void handleAudioData(OpusAudioData audioData) {
        byte[] d;
        super.handleAudioData(audioData);
        long gp = audioData.getGranulePosition();
        if (gp != this.lastgranulepos) {
            ++this.page_count;
            if (gp > 0L) {
                if (gp < this.lastgranulepos) {
                    System.err.println("WARNING: granulepos in stream " + this.sid + " decreases from " + this.lastgranulepos + " to " + gp);
                }
                if (this.lastgranulepos == 0L && this.firstgranulepos == -1L) {
                    this.firstgranulepos = gp;
                    if (this.firstgranulepos < 0L) {
                        if (!audioData.isEndOfStream()) {
                            System.err.println("WARNING:Samples with negative granpos in stream " + this.sid);
                        } else {
                            this.firstgranulepos = 0L;
                        }
                    }
                }
                if (this.lastlastgranulepos == 0L) {
                    this.firstgranulepos -= (long)this.page_samples;
                }
                if ((long)this.total_samples < this.lastgranulepos - this.firstgranulepos) {
                    System.err.println("WARNING: Sample count behind granule (" + this.total_samples + "<" + (this.lastgranulepos - this.firstgranulepos) + ") in stream " + this.sid);
                }
                if (!audioData.isEndOfStream() && (long)this.total_samples > gp - this.firstgranulepos) {
                    System.err.println("WARNING: Sample count ahead granule (" + this.total_samples + "<" + this.firstgranulepos + ") in stream" + this.sid);
                }
                this.lastlastgranulepos = this.lastgranulepos;
                this.lastgranulepos = gp;
                if (this.getAudioPacketsCount() == 0) {
                    System.err.println("WARNING: Page with positive granpos (" + gp + ") on a page with no completed packets in stream " + this.sid);
                }
            } else if (this.getAudioPacketsCount() == 0) {
                System.err.println("Negative or zero granulepos (" + gp + ") on Opus stream outside of headers. This file was created by a buggy encoder");
            }
            if (this.max_page_duration < this.page_samples) {
                this.max_page_duration = this.page_samples;
            }
            if (this.page_count > 1 && this.min_page_duration > this.page_samples) {
                this.min_page_duration = this.page_samples;
            }
            this.page_samples = 0;
        }
        if ((d = audioData.getData()).length < 1) {
            System.err.println("WARNING: Invalid packet TOC in stream with sid " + this.sid);
            return;
        }
        int samples = audioData.getNumberOfSamples();
        if (samples < 120 || samples > 5760 || samples % 120 != 0) {
            System.err.println("WARNING: Invalid packet TOC in stream with sid " + this.sid);
            return;
        }
        this.total_samples += samples;
        this.page_samples += samples;
        ++this.total_packets;
        if (this.max_packet_duration < samples) {
            this.max_packet_duration = samples;
        }
        if (this.min_packet_duration > samples) {
            this.min_packet_duration = samples;
        }
        if (this.max_packet_bytes < d.length) {
            this.max_packet_bytes = d.length;
        }
        if (this.min_packet_bytes > d.length) {
            this.min_packet_bytes = d.length;
        }
    }

    public double getMaxPacketDuration() {
        return (double)this.max_packet_duration / 48.0;
    }

    public double getAvgPacketDuration() {
        if (this.total_packets > 0) {
            return (double)(this.total_samples / this.total_packets) / 48.0;
        }
        return 0.0;
    }

    public double getMinPacketDuration() {
        return (double)this.min_packet_duration / 48.0;
    }

    public double getMaxPageDuration() {
        return (double)this.max_page_duration / 48.0;
    }

    public double getAvgPageDuration() {
        if (this.total_pages > 0) {
            return (double)this.total_samples / (double)this.total_pages / 48.0;
        }
        return 0.0;
    }

    public double getMinPageDuration() {
        return (double)this.min_page_duration / 48.0;
    }

    public int getMaxPacketBytes() {
        return this.max_packet_bytes;
    }

    public int getMinPacketBytes() {
        return this.min_packet_bytes;
    }
}

