/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.opus;

import vminus.shadow.org.gagravarr.ogg.HighLevelOggStreamPacket;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioInfoHeader;
import vminus.shadow.org.gagravarr.opus.OpusPacket;

public class OpusInfo
extends HighLevelOggStreamPacket
implements OpusPacket,
OggAudioInfoHeader {
    private byte version;
    private int majorVersion;
    private int minorVersion;
    private int channels;
    private int preSkip;
    private long rate;
    private int outputGain;
    private byte channelMappingFamily;
    private byte streamCount;
    private byte twoChannelStreamCount;
    private byte[] channelMapping;

    public OpusInfo() {
        this.version = 1;
    }

    public OpusInfo(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        if (!IOUtils.byteRangeMatches(MAGIC_HEADER_BYTES, data, 0)) {
            throw new IllegalArgumentException("Invalid type, not a Opus Header");
        }
        this.version = data[8];
        this.parseVersion();
        if (this.majorVersion != 0) {
            throw new IllegalArgumentException("Unsupported Opus version " + this.version + " at major version " + this.majorVersion + " detected");
        }
        this.channels = data[9];
        this.preSkip = IOUtils.getInt2(data, 10);
        this.rate = IOUtils.getInt4(data, 12);
        this.outputGain = IOUtils.getInt2(data, 16);
        this.channelMappingFamily = data[18];
        if (this.channelMappingFamily != 0) {
            this.streamCount = data[19];
            this.twoChannelStreamCount = data[20];
            this.channelMapping = new byte[this.channels];
            System.arraycopy(data, 21, this.channelMapping, 0, this.channels);
        }
    }

    public OggPacket write() {
        int length = 19;
        if (this.channelMappingFamily != 0) {
            length += 2;
            length += this.channels;
        }
        byte[] data = new byte[length];
        System.arraycopy(MAGIC_HEADER_BYTES, 0, data, 0, 8);
        data[8] = this.version;
        data[9] = (byte)this.channels;
        IOUtils.putInt2(data, 10, this.preSkip);
        IOUtils.putInt4(data, 12, this.rate);
        IOUtils.putInt2(data, 16, this.outputGain);
        data[18] = this.channelMappingFamily;
        if (this.channelMappingFamily != 0) {
            data[19] = this.streamCount;
            data[20] = this.twoChannelStreamCount;
            System.arraycopy(this.channelMapping, 0, data, 21, this.channels);
        }
        this.setData(data);
        return super.write();
    }

    private void parseVersion() {
        this.minorVersion = this.version & 0xF;
        this.majorVersion = this.version >> 4;
    }

    public byte getVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersionString() {
        return this.majorVersion + "." + this.minorVersion;
    }

    public int getNumChannels() {
        return this.channels;
    }

    public void setNumChannels(int channels) {
        this.channels = channels;
    }

    public int getPreSkip() {
        return this.preSkip;
    }

    public void setPreSkip(int preSkip) {
        this.preSkip = preSkip;
    }

    public long getRate() {
        return this.rate;
    }

    public int getSampleRate() {
        return (int)this.rate;
    }

    public void setSampleRate(long rate) {
        this.rate = rate;
    }

    public int getOutputGain() {
        return this.outputGain;
    }

    public void setOutputGain(int outputGain) {
        this.outputGain = outputGain;
    }

    public byte getChannelMappingFamily() {
        return this.channelMappingFamily;
    }

    public byte getStreamCount() {
        return this.streamCount;
    }

    public byte getTwoChannelStreamCount() {
        return this.twoChannelStreamCount;
    }

    public byte[] getChannelMapping() {
        return this.channelMapping;
    }
}

