/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.ogg.audio;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import vminus.shadow.org.gagravarr.ogg.OggStreamAudioData;
import vminus.shadow.org.gagravarr.ogg.OggStreamPacket;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioHeaders;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioInfoHeader;
import vminus.shadow.org.gagravarr.ogg.audio.OggAudioStream;
import vminus.shadow.org.gagravarr.opus.OpusInfo;

public class OggAudioStatistics {
    private final OggAudioStream audio;
    private final OggAudioHeaders headers;
    private int audioPackets = 0;
    private long lastGranule = -1L;
    private double durationSeconds = 0.0;
    private long oggOverheadSize = 0L;
    private long headerOverheadSize = 0L;
    private long audioDataSize = 0L;

    public OggAudioStatistics(OggAudioHeaders headers, OggAudioStream audio) throws IOException {
        this.audio = audio;
        this.headers = headers;
    }

    public void calculate() throws IOException {
        OggStreamAudioData data;
        OggAudioInfoHeader info = this.headers.getInfo();
        this.handleHeader(info);
        this.handleHeader(this.headers.getTags());
        this.handleHeader(this.headers.getSetup());
        while ((data = this.audio.getNextAudioPacket()) != null) {
            this.handleAudioData(data);
        }
        if (this.lastGranule > 0L) {
            long samples = this.lastGranule - (long)info.getPreSkip();
            double sampleRate = info.getSampleRate();
            if (info instanceof OpusInfo) {
                sampleRate = 48000.0;
            }
            this.durationSeconds = (double)samples / sampleRate;
        }
    }

    protected void handleHeader(OggStreamPacket header) {
        if (header != null) {
            this.oggOverheadSize += (long)header.getOggOverheadSize();
            this.headerOverheadSize += (long)header.getData().length;
        }
    }

    protected void handleAudioData(OggStreamAudioData audioData) {
        ++this.audioPackets;
        this.audioDataSize += (long)audioData.getData().length;
        this.oggOverheadSize += (long)audioData.getOggOverheadSize();
        if (audioData.getGranulePosition() > this.lastGranule) {
            this.lastGranule = audioData.getGranulePosition();
        }
    }

    public double getDurationSeconds() {
        return this.durationSeconds;
    }

    public String getDuration() {
        long durationL = (long)this.durationSeconds;
        long hours = TimeUnit.SECONDS.toHours(durationL);
        long mins = TimeUnit.SECONDS.toMinutes(durationL) - hours * 60L;
        double secs = this.durationSeconds - (double)((hours * 60L + mins) * 60L);
        return String.format("%02d:%02d:%05.2f", hours, mins, secs);
    }

    public long getLastGranule() {
        return this.lastGranule;
    }

    public int getAudioPacketsCount() {
        return this.audioPackets;
    }

    public long getAudioDataSize() {
        return this.audioDataSize;
    }

    public long getHeaderOverheadSize() {
        return this.headerOverheadSize;
    }

    public float getOggOverheadPercentage() {
        long total = this.audioDataSize + this.headerOverheadSize + this.oggOverheadSize;
        return 100.0f * (float)this.oggOverheadSize / (float)total;
    }

    public long getOggOverheadSize() {
        return this.oggOverheadSize;
    }

    public double getAverageOverallBitrate() {
        long total = this.audioDataSize + this.headerOverheadSize + this.oggOverheadSize;
        return (double)total * 8.0 / this.durationSeconds;
    }

    public double getAverageAudioBitrate() {
        return (double)this.audioDataSize * 8.0 / this.durationSeconds;
    }
}

