/*
 * Decompiled with CFR 0.152.
 */
package vminus.shadow.org.gagravarr.ogg;

import vminus.shadow.org.gagravarr.flac.FlacFirstOggPacket;
import vminus.shadow.org.gagravarr.ogg.IOUtils;
import vminus.shadow.org.gagravarr.ogg.OggPacket;
import vminus.shadow.org.gagravarr.opus.OpusPacketFactory;
import vminus.shadow.org.gagravarr.skeleton.SkeletonPacketFactory;
import vminus.shadow.org.gagravarr.speex.SpeexPacketFactory;
import vminus.shadow.org.gagravarr.theora.TheoraPacketFactory;
import vminus.shadow.org.gagravarr.vorbis.VorbisPacketFactory;

public class OggStreamIdentifier {
    public static final OggStreamType OGG_GENERAL = new OggStreamType("application/ogg", "Ogg", OggStreamType.Kind.GENERAL);
    public static final OggStreamType OGG_VIDEO = new OggStreamType("video/ogg", "Ogg Video", OggStreamType.Kind.VIDEO);
    public static final OggStreamType OGG_AUDIO = new OggStreamType("audio/ogg", "Ogg Audio", OggStreamType.Kind.AUDIO);
    public static final OggStreamType UNKNOWN = new OggStreamType("application/octet-stream", "Unknown", OggStreamType.Kind.GENERAL);
    public static final OggStreamType OGG_VORBIS = new OggStreamType("audio/vorbis", "Vorbis", OggStreamType.Kind.AUDIO);
    public static final OggStreamType OPUS_AUDIO = new OggStreamType("audio/opus", "Opus", OggStreamType.Kind.AUDIO);
    public static final OggStreamType OPUS_AUDIO_ALT = new OggStreamType("audio/ogg; codecs=opus", "Opus", OggStreamType.Kind.AUDIO);
    public static final OggStreamType SPEEX_AUDIO = new OggStreamType("audio/speex", "Speex", OggStreamType.Kind.AUDIO);
    public static final OggStreamType SPEEX_AUDIO_ALT = new OggStreamType("audio/ogg; codecs=speex", "Speex", OggStreamType.Kind.AUDIO);
    public static final OggStreamType OGG_PCM = new OggStreamType("audio/x-oggpcm", "Ogg PCM", OggStreamType.Kind.AUDIO);
    public static final OggStreamType NATIVE_FLAC = new OggStreamType("audio/x-flac", "FLAC", OggStreamType.Kind.AUDIO);
    public static final OggStreamType OGG_FLAC = new OggStreamType("audio/x-oggflac", "FLAC", OggStreamType.Kind.AUDIO);
    public static final OggStreamType THEORA_VIDEO = new OggStreamType("video/theora", "Theora", OggStreamType.Kind.VIDEO);
    public static final OggStreamType THEORA_VIDEO_ALT = new OggStreamType("video/x-theora", "Theora", OggStreamType.Kind.VIDEO);
    public static final OggStreamType DAALA_VIDEO = new OggStreamType("video/daala", "Daala", OggStreamType.Kind.VIDEO);
    public static final OggStreamType DIRAC_VIDEO = new OggStreamType("video/x-dirac", "Dirac", OggStreamType.Kind.VIDEO);
    public static final OggStreamType OGM_VIDEO = new OggStreamType("video/x-ogm", "Ogg OGM", OggStreamType.Kind.VIDEO);
    public static final OggStreamType OGG_UVS = new OggStreamType("video/x-ogguvs", "Ogg UVS", OggStreamType.Kind.VIDEO);
    public static final OggStreamType OGG_YUV = new OggStreamType("video/x-oggyuv", "Ogg YUV", OggStreamType.Kind.VIDEO);
    public static final OggStreamType OGG_RGB = new OggStreamType("video/x-oggrgb", "Ogg RGB", OggStreamType.Kind.VIDEO);
    public static final OggStreamType SKELETON = new OggStreamType("application/annodex", "Skeleton Annodex", OggStreamType.Kind.METADATA);
    public static final OggStreamType CMML = new OggStreamType("text/x-cmml", "CMML", OggStreamType.Kind.METADATA);
    public static final OggStreamType KATE = new OggStreamType("application/kate", "Kate", OggStreamType.Kind.METADATA);
    protected static final byte[] MAGIC_OGG_PCM = IOUtils.toUTF8Bytes("PCM     ");
    protected static final byte[] MAGIC_DAALA = new byte[8];
    protected static final byte[] MAGIC_DIRAC;
    protected static final byte[] MAGIC_OGG_OGM;
    protected static final byte[] MAGIC_OGG_UVS;
    protected static final byte[] MAGIC_OGG_YUV;
    protected static final byte[] MAGIC_OGG_RGB;
    protected static final byte[] MAGIC_CMML;
    protected static final byte[] MAGIC_KATE;
    protected static final byte[] MAGIC_ANNODEX2;

    public static OggStreamType identifyType(OggPacket p) {
        if (!p.isBeginningOfStream()) {
            throw new IllegalArgumentException("Can only Identify from the first packet in a stream");
        }
        if (p.getData() != null && p.getData().length > 10) {
            if (SkeletonPacketFactory.isSkeletonStream(p)) {
                return SKELETON;
            }
            if (OggStreamIdentifier.isAnnodex2Stream(p)) {
                return SKELETON;
            }
            if (OggStreamIdentifier.isCMMLStream(p)) {
                return CMML;
            }
            if (OggStreamIdentifier.isKateStream(p)) {
                return KATE;
            }
            if (VorbisPacketFactory.isVorbisStream(p)) {
                return OGG_VORBIS;
            }
            if (SpeexPacketFactory.isSpeexStream(p)) {
                return SPEEX_AUDIO;
            }
            if (OpusPacketFactory.isOpusStream(p)) {
                return OPUS_AUDIO;
            }
            if (FlacFirstOggPacket.isFlacStream(p)) {
                return OGG_FLAC;
            }
            if (OggStreamIdentifier.isOggPCMStream(p)) {
                return OGG_PCM;
            }
            if (TheoraPacketFactory.isTheoraStream(p)) {
                return THEORA_VIDEO;
            }
            if (OggStreamIdentifier.isDaalaStream(p)) {
                return DAALA_VIDEO;
            }
            if (OggStreamIdentifier.isDiracStream(p)) {
                return DIRAC_VIDEO;
            }
            if (OggStreamIdentifier.isOggOGMStream(p)) {
                return OGM_VIDEO;
            }
            if (OggStreamIdentifier.isOggUVSStream(p)) {
                return OGG_UVS;
            }
            if (OggStreamIdentifier.isOggYUVStream(p)) {
                return OGG_YUV;
            }
            if (OggStreamIdentifier.isOggRGBStream(p)) {
                return OGG_RGB;
            }
        }
        return UNKNOWN;
    }

    protected static boolean isOggPCMStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_OGG_PCM, p.getData(), 0);
    }

    protected static boolean isDaalaStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_DAALA, p.getData(), 0);
    }

    protected static boolean isDiracStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_DIRAC, p.getData(), 0);
    }

    protected static boolean isOggOGMStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_OGG_OGM, p.getData(), 0);
    }

    protected static boolean isOggUVSStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_OGG_UVS, p.getData(), 0);
    }

    protected static boolean isOggYUVStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_OGG_YUV, p.getData(), 0);
    }

    protected static boolean isOggRGBStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_OGG_RGB, p.getData(), 0);
    }

    protected static boolean isCMMLStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_CMML, p.getData(), 0);
    }

    protected static boolean isKateStream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_KATE, p.getData(), 0);
    }

    protected static boolean isAnnodex2Stream(OggPacket p) {
        return IOUtils.byteRangeMatches(MAGIC_ANNODEX2, p.getData(), 0);
    }

    static {
        OggStreamIdentifier.MAGIC_DAALA[0] = -128;
        IOUtils.putUTF8(MAGIC_DAALA, 1, "daala");
        MAGIC_DIRAC = IOUtils.toUTF8Bytes("BBCD");
        MAGIC_OGG_OGM = IOUtils.toUTF8Bytes("video");
        MAGIC_OGG_UVS = IOUtils.toUTF8Bytes("UVS ");
        MAGIC_OGG_YUV = IOUtils.toUTF8Bytes("\u0001YUV");
        MAGIC_OGG_RGB = IOUtils.toUTF8Bytes("\u0001GBP");
        MAGIC_CMML = IOUtils.toUTF8Bytes("CMML\u0000\u0000\u0000\u0000");
        MAGIC_KATE = new byte[8];
        OggStreamIdentifier.MAGIC_KATE[0] = -128;
        IOUtils.putUTF8(MAGIC_KATE, 1, "kate");
        MAGIC_ANNODEX2 = IOUtils.toUTF8Bytes("Annodex\u0000");
    }

    public static class OggStreamType {
        public final String mimetype;
        public final String description;
        public final Kind kind;

        protected OggStreamType(String mimetype, String description, Kind kind) {
            this.mimetype = mimetype;
            this.description = description;
            this.kind = kind;
        }

        public String toString() {
            return (Object)((Object)this.kind) + " - " + this.description + " as " + this.mimetype;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            GENERAL,
            AUDIO,
            VIDEO,
            METADATA;

        }
    }
}

