/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision.values;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.lixir.vminus.vision.values.conditions.AbstractVisionCondition;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.util.Mth;

public class VisionValue<T> {
    public static short DEFAULT_PRIORITY = (short)500;
    public static short MIN_PRIORITY = 0;
    public static short MAX_PRIORITY = (short)1000;
    public static String PRIORITY_TAG = "/priority";
    private final ImmutableList<ImmutableList<AbstractVisionCondition>> conditions;
    private final short priority;
    private final T value;

    public VisionValue(T value, List<List<AbstractVisionCondition>> conditions) {
        this.conditions = (ImmutableList)conditions.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        this.value = value;
        this.priority = DEFAULT_PRIORITY;
    }

    public VisionValue(T value, List<List<AbstractVisionCondition>> conditions, short priority) {
        this.conditions = (ImmutableList)conditions.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        this.value = value;
        this.priority = (short)Mth.m_14045_((int)priority, (int)MIN_PRIORITY, (int)MAX_PRIORITY);
    }

    public static <T> VisionValue<T> create(T value, JsonObject arrayObject, JsonObject jsonObject, String key) {
        return new VisionValue<T>(value, AbstractVisionCondition.parseVisionConditions(arrayObject, jsonObject), VisionValue.getPriorityFromJsonObject(jsonObject, key));
    }

    private static short getPriorityFromJsonObject(JsonObject jsonObject, String key) throws JsonParseException {
        String priorityName = key + PRIORITY_TAG;
        if (jsonObject.has(priorityName)) {
            if (!jsonObject.get(priorityName).isJsonPrimitive()) {
                throw new JsonParseException(key + " priority value is not a JsonPrimitive.");
            }
            JsonPrimitive jsonPrimitive = jsonObject.get(priorityName).getAsJsonPrimitive();
            return jsonPrimitive.getAsShort();
        }
        return 0;
    }

    public ImmutableList<ImmutableList<AbstractVisionCondition>> getConditions() {
        return this.conditions;
    }

    public short getPriority() {
        return this.priority;
    }

    public boolean testConditions(@Nullable VisionContext visionContext) {
        if (visionContext == null || this.conditions.isEmpty()) {
            return true;
        }
        for (List visionConditionList : this.conditions) {
            if (!visionConditionList.stream().allMatch(c -> c.test(visionContext) != c.isInverted())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VisionValue other = (VisionValue)obj;
        return this.priority == other.priority && Objects.equals(this.value, other.value) && Objects.equals(this.conditions, other.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.priority, this.conditions);
    }

    public String toString() {
        return "VisionProperty{value=" + this.value + ", priority=" + this.priority + ", conditions=" + this.conditions + "}";
    }

    public boolean isConstant() {
        return this.conditions.isEmpty();
    }

    public T getValue() {
        return this.value;
    }
}

