/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision.util;

import java.util.Arrays;
import java.util.List;
import net.lixir.vminus.resources.data.bans.BannedRecipeManager;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.VisionProperty;
import net.lixir.vminus.vision.util.ItemReplacement;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class VisionUtils {
    public static boolean isRecipeBanned(Recipe<?> recipe, ResourceLocation id, RegistryAccess access) {
        if (BannedRecipeManager.INSTANCE.isBanned(id)) {
            return true;
        }
        ItemStack result = recipe.m_8043_(access);
        if (VisionUtils.isBanned(result.m_41720_())) {
            return true;
        }
        return recipe.m_7527_().stream().flatMap(ing -> Arrays.stream(ing.m_43908_())).map(ItemStack::m_41720_).allMatch(VisionUtils::isBanned);
    }

    @Nullable
    public static <T> T getOverrideValue(VisionDuck visionDuck, @NotNull VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        Vision vision = Vision.get(visionDuck);
        return vision.getValue(visionProperty, visionContext);
    }

    public static <T> T tryOverride(CallbackInfoReturnable<T> cir, VisionDuck visionDuck, VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        T value = VisionUtils.getOverrideValue(visionDuck, visionProperty, visionContext);
        if (value != null) {
            cir.setReturnValue(value);
        }
        return value;
    }

    public static boolean isItemBannedOrReplaced(ItemStack stack, ItemReplacement replacement) {
        return VisionUtils.isItemBannedOrReplaced(replacement, VisionUtils.isBanned(stack));
    }

    public static boolean isItemBannedOrReplaced(ItemStack stack, boolean banned) {
        ItemReplacement replacement = ItemReplacement.from(stack);
        return VisionUtils.isItemBannedOrReplaced(replacement, banned);
    }

    public static boolean isItemBannedOrReplaced(ItemStack stack) {
        ItemReplacement replacement = ItemReplacement.from(stack);
        return VisionUtils.isItemBannedOrReplaced(replacement, VisionUtils.isBanned(stack));
    }

    public static boolean isItemBannedOrReplaced(ItemReplacement replacement, boolean banned) {
        return replacement != null && (replacement.itemStack() != null || replacement.tag() != null) || banned;
    }

    public static <T> T tryCancel(CallbackInfo ci, VisionDuck visionDuck, VisionProperty<T> visionProperty, @Nullable VisionContext visionContext) {
        T value = VisionUtils.getOverrideValue(visionDuck, visionProperty, visionContext);
        if (value != null) {
            ci.cancel();
        }
        return value;
    }

    public static void filterIngredient(ItemStack stack, List<ItemStack> replacedItems) {
        ItemReplacement replacement = ItemReplacement.from(stack);
        if (replacement != null) {
            ITag tag;
            if (replacement.itemStack() != null) {
                replacedItems.add(replacement.itemStack());
                return;
            }
            if (replacement.tag() != null && !(tag = ForgeRegistries.ITEMS.tags().getTag(replacement.tag())).isEmpty()) {
                for (Item item : tag) {
                    replacedItems.add(item.m_7968_());
                }
                return;
            }
        }
        if (!VisionUtils.isItemBannedOrReplaced(stack, replacement)) {
            replacedItems.add(stack.m_41777_());
        }
    }

    public static boolean isBanned(Item item) {
        Boolean ban = Vision.getValue(item, VisionProperties.Items.BAN);
        ItemReplacement replacement = Vision.getValue(item, VisionProperties.Items.REPLACE);
        return Boolean.TRUE.equals(ban) && ItemReplacement.resolve(replacement).m_41619_();
    }

    public static boolean isBanned(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        Boolean ban = Vision.getValue(stack, VisionProperties.Items.BAN);
        ItemReplacement replacement = Vision.getValue(stack, VisionProperties.Items.REPLACE);
        return Boolean.TRUE.equals(ban) && ItemReplacement.resolve(replacement).m_41619_();
    }
}

