/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision.util;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record ItemReplacement(@Nullable ItemStack itemStack, @Nullable TagKey<Item> tag) {
    @Nullable
    private final ItemStack itemStack;

    @Nullable
    public ItemStack itemStack() {
        return this.itemStack != null ? this.itemStack.m_41777_() : null;
    }

    @Nullable
    public static ItemReplacement from(Item item) {
        return ItemReplacement.from(item, new VisionContext(item));
    }

    @Nullable
    public static ItemReplacement from(ItemStack stack) {
        return ItemReplacement.from(stack, new VisionContext(stack));
    }

    @Nullable
    public static ItemReplacement from(Item item, @Nullable VisionContext visionContext) {
        return Vision.getValue(item, VisionProperties.Items.REPLACE, visionContext);
    }

    @Nullable
    public static ItemReplacement from(ItemStack stack, @Nullable VisionContext visionContext) {
        return Vision.getValue(stack, VisionProperties.Items.REPLACE, visionContext);
    }

    @NotNull
    public static ItemStack resolve(ItemStack stack) {
        return ItemReplacement.resolve(ItemReplacement.from(stack));
    }

    @NotNull
    public static ItemStack resolve(Item item) {
        return ItemReplacement.resolve(ItemReplacement.from(item));
    }

    @NotNull
    public static ItemStack resolve(@Nullable ItemReplacement replacement) {
        if (replacement == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = replacement.itemStack();
        TagKey<Item> tag = replacement.tag();
        if (itemStack != null && !itemStack.m_41619_()) {
            return itemStack;
        }
        if (tag != null) {
            return BuiltInRegistries.f_257033_.m_203431_(tag).flatMap(tagContents -> tagContents.m_203614_().findFirst()).map(Holder::m_203334_).orElse(ItemStack.f_41583_.m_41720_()).m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public static boolean tryReplace(ItemStack original, Consumer<ItemStack> apply) {
        ItemReplacement replacement = Vision.getValue(original, VisionProperties.Items.REPLACE);
        ItemStack replaced = ItemReplacement.resolve(replacement);
        if (!replaced.m_41619_()) {
            replaced.m_41764_(original.m_41613_());
            apply.accept(replaced);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ItemReplacement[itemStack=" + this.itemStack + ", tag=" + this.tag + "]";
    }
}

