/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.vision;

import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class VisionProperty<T> {
    private final String id;
    private final VisionCodec<T> codec;
    private final boolean syncToClient;

    public VisionProperty(String id, VisionCodec<T> codec, boolean syncToClient) {
        this.id = id;
        this.codec = codec;
        this.syncToClient = syncToClient;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T> VisionProperty<T> create(String id, VisionCodec<T> codec) {
        return new VisionProperty<T>(id, codec, true);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T> VisionProperty<T> create(String id, VisionCodec<T> codec, boolean syncToClient) {
        return new VisionProperty<T>(id, codec, syncToClient);
    }

    public String getId() {
        return this.id;
    }

    public VisionCodec<T> getCodec() {
        return this.codec;
    }

    public boolean shouldSyncToClient() {
        return this.syncToClient;
    }
}

