/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.util;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ParticleUtil {
    public static Vec3 calculateVelocity(double spawnX, double spawnY, double spawnZ, double targetX, double targetY, double targetZ, double speed) {
        double dirX = targetX - spawnX;
        double dirY = targetY - spawnY;
        double dirZ = targetZ - spawnZ;
        double length = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (length > 0.0) {
            dirX /= length;
            dirY /= length;
            dirZ /= length;
        }
        return new Vec3(dirX * speed, dirY * speed, dirZ * speed);
    }

    public static void spawnParticlesBetweenPoints(ClientLevel world, Vec3 startPoint, Vec3 endPoint, double particleAmount, SimpleParticleType particleType, float spread) {
        double xStep = (endPoint.f_82479_ - startPoint.f_82479_) / particleAmount;
        double yStep = (endPoint.f_82480_ - startPoint.f_82480_) / particleAmount;
        double zStep = (endPoint.f_82481_ - startPoint.f_82481_) / particleAmount;
        RandomSource random = RandomSource.m_216327_();
        int i = 0;
        while ((double)i < particleAmount) {
            double newX = startPoint.f_82479_ + xStep * (double)i;
            double newY = startPoint.f_82480_ + yStep * (double)i;
            double newZ = startPoint.f_82481_ + zStep * (double)i;
            world.m_7106_((ParticleOptions)particleType, newX, newY, newZ, Mth.m_216263_((RandomSource)random, (double)(-spread), (double)spread), Mth.m_216263_((RandomSource)random, (double)(-spread), (double)spread), Mth.m_216263_((RandomSource)random, (double)(-spread), (double)spread));
            ++i;
        }
    }

    public static void spawnParticlesBetweenPoints(ServerLevel world, Vec3 startPoint, Vec3 endPoint, int particleAmount, SimpleParticleType particleType, float spread) {
        double xStep = (endPoint.f_82479_ - startPoint.f_82479_) / (double)particleAmount;
        double yStep = (endPoint.f_82480_ - startPoint.f_82480_) / (double)particleAmount;
        double zStep = (endPoint.f_82481_ - startPoint.f_82481_) / (double)particleAmount;
        for (int i = 0; i < particleAmount; ++i) {
            double newX = startPoint.f_82479_ + xStep * (double)i;
            double newY = startPoint.f_82480_ + yStep * (double)i;
            double newZ = startPoint.f_82481_ + zStep * (double)i;
            world.m_8767_((ParticleOptions)particleType, newX, newY, newZ, 1, (double)spread, (double)spread, (double)spread, Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-0.025, (double)0.025));
        }
    }

    public static void spawnParticlesBetweenEntities(ServerLevel world, Entity entity1, Entity entity2, int particleAmount, SimpleParticleType particleType, float spread) {
        double xOffset1 = 0.0;
        double yOffset1 = (double)entity1.m_20206_() / 2.0;
        double zOffset1 = 0.0;
        double xOffset2 = 0.0;
        double yOffset2 = (double)entity2.m_20206_() / 2.0;
        double zOffset2 = 0.0;
        Vec3 startPoint = entity1.m_20182_().m_82520_(xOffset1, yOffset1, zOffset1);
        Vec3 endPoint = entity2.m_20182_().m_82520_(xOffset2, yOffset2, zOffset2);
        double xStep = (endPoint.f_82479_ - startPoint.f_82479_) / (double)particleAmount;
        double yStep = (endPoint.f_82480_ - startPoint.f_82480_) / (double)particleAmount;
        double zStep = (endPoint.f_82481_ - startPoint.f_82481_) / (double)particleAmount;
        for (int i = 0; i < particleAmount; ++i) {
            double newX = startPoint.f_82479_ + xStep * (double)i;
            double newY = startPoint.f_82480_ + yStep * (double)i;
            double newZ = startPoint.f_82481_ + zStep * (double)i;
            world.m_8767_((ParticleOptions)particleType, newX, newY, newZ, 1, (double)spread, (double)spread, (double)spread, Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)-0.025, (double)0.025));
        }
    }
}

