/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionSoundEventCodec
extends VisionCodec<SoundEvent> {
    @Override
    public Class<SoundEvent> getClassType() {
        return SoundEvent.class;
    }

    @Override
    @Nullable
    public List<VisionValue<SoundEvent>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<SoundEvent>> visionProperties = new ArrayList<VisionValue<SoundEvent>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            SoundEvent value;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            try {
                String soundId = arrayObject.getAsJsonPrimitive("sound").getAsString();
                ResourceLocation rl = new ResourceLocation(soundId);
                value = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(rl);
                if (value == null) {
                    throw new JsonParseException("Unknown SoundEvent: " + soundId);
                }
            }
            catch (Exception e) {
                VMinus.LOGGER.error("Failed to parse SoundEvent from: {}", (Object)jsonObject);
                throw new JsonParseException((Throwable)e);
            }
            visionProperties.add(VisionValue.create(value, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull SoundEvent value) {
        ResourceLocation id = BuiltInRegistries.f_256894_.m_7981_((Object)value);
        if (id == null) {
            VMinus.LOGGER.warn("Unknown SoundEvent when encoding: {}", (Object)value);
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("sound", id.toString());
        return jsonObject;
    }
}

