/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionHexCodec
extends VisionCodec<Integer> {
    @Override
    public Class<Integer> getClassType() {
        return Integer.class;
    }

    @Override
    @Nullable
    public List<VisionValue<Integer>> decode(JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<Integer>> visionProperties = new ArrayList<VisionValue<Integer>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            String value = arrayObject.getAsJsonPrimitive("value").getAsString();
            if (value.startsWith("#")) {
                value = value.substring(1);
            }
            int colorInt = Integer.parseInt(value, 16);
            visionProperties.add(VisionValue.create(colorInt, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull Integer value) {
        return VisionHexCodec.encodeInteger(value);
    }
}

