/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionFloatCodec
extends VisionCodec<Float> {
    @Override
    public Class<Float> getClassType() {
        return Float.class;
    }

    @Override
    @Nullable
    public List<VisionValue<Float>> decode(JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<Float>> visionProperties = new ArrayList<VisionValue<Float>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            float value = arrayObject.getAsJsonPrimitive("value").getAsFloat();
            visionProperties.add(VisionValue.create(Float.valueOf(value), arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull Float value) {
        JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("value", (JsonElement)jsonPrimitive);
        return jsonObject;
    }
}

