/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionEnumCodec<E extends Enum<E>>
extends VisionCodec<E> {
    private final Class<E> enumType;

    @Override
    public Class<E> getClassType() {
        return this.enumType;
    }

    public VisionEnumCodec(Class<E> enumType) {
        this.enumType = enumType;
    }

    @Override
    @Nullable
    public List<VisionValue<E>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<VisionValue<E>>> visionProperties = new ArrayList<VisionValue<VisionValue<E>>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            E enumValue;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            String valueString = arrayObject.getAsJsonPrimitive("value").getAsString();
            try {
                enumValue = Enum.valueOf(this.enumType, valueString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(valueString + " is not a valid value for enum " + this.enumType.getSimpleName());
            }
            VisionValue<E> visionValue = VisionValue.create(enumValue, arrayObject, jsonObject, key);
            visionProperties.add(visionValue);
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull E value) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", ((Enum)value).name().toLowerCase());
        return jsonObject;
    }
}

