/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.List;
import javax.annotation.Nullable;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class VisionCodec<V> {
    protected VisionCodec() {
    }

    public abstract Class<V> getClassType();

    protected static ResourceLocation parseResourceLocation(String key, JsonObject jsonObject) throws JsonParseException {
        return VisionCodec.parseResourceLocation("value", key, jsonObject);
    }

    protected static ResourceLocation parseResourceLocation(String valueName, String key, JsonObject jsonObject) throws JsonParseException {
        ResourceLocation resourceLocation;
        String id;
        try {
            id = jsonObject.getAsJsonPrimitive(valueName).getAsString();
        }
        catch (Exception e) {
            throw new JsonParseException(key + " does not have " + valueName + ".");
        }
        try {
            resourceLocation = new ResourceLocation(id);
        }
        catch (Exception e) {
            throw new JsonParseException(id + " is not a valid resource location for " + key + ".");
        }
        return resourceLocation;
    }

    @NotNull
    public static JsonObject encodeInteger(Integer value) {
        JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("value", (JsonElement)jsonPrimitive);
        return jsonObject;
    }

    @NotNull
    protected static SoundEvent parseSoundInObject(@NotNull JsonObject jsonObject, String key, SoundEvent fallback) throws JsonParseException {
        if (jsonObject.has(key)) {
            ResourceLocation soundLocation;
            String soundString = jsonObject.getAsJsonPrimitive(key).getAsString();
            try {
                soundLocation = new ResourceLocation(soundString);
            }
            catch (Exception e) {
                throw new JsonParseException(soundString + " is an invalid sound location for " + key);
            }
            SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
            if (soundEvent != null) {
                return soundEvent;
            }
            throw new JsonParseException(soundString + " as " + key + " does not exist in the sound registries");
        }
        return fallback;
    }

    @Nullable
    public abstract List<VisionValue<V>> decode(JsonObject var1, String var2) throws JsonParseException;

    @Nullable
    public abstract JsonObject encode(@NotNull V var1);
}

