/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionBooleanCodec
extends VisionCodec<Boolean> {
    @Override
    public Class<Boolean> getClassType() {
        return Boolean.class;
    }

    @Override
    @Nullable
    public List<VisionValue<Boolean>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<Boolean>> visionProperties = new ArrayList<VisionValue<Boolean>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            boolean value = arrayObject.getAsJsonPrimitive("value").getAsBoolean();
            visionProperties.add(VisionValue.create(value, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull Boolean value) {
        JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("value", (JsonElement)jsonPrimitive);
        return jsonObject;
    }
}

