/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VisionFormatter {
    @NotNull
    public static JsonObject processJson(String singleListName, String multiListName, @NotNull JsonElement jsonFile) throws JsonParseException {
        JsonObject jsonFileObject = jsonFile.getAsJsonObject();
        if (!jsonFileObject.has(multiListName)) {
            jsonFileObject.add(multiListName, (JsonElement)new JsonArray());
        }
        VisionFormatter.keyToArray(jsonFileObject, singleListName, multiListName);
        VisionFormatter.keyToArray(jsonFileObject, "tag", multiListName);
        JsonObject processedJsonObject = new JsonObject();
        if (jsonFileObject.has(multiListName) && jsonFileObject.get(multiListName).isJsonArray()) {
            processedJsonObject.add(multiListName, jsonFileObject.get(multiListName));
        }
        for (Map.Entry entry : jsonFileObject.entrySet()) {
            JsonArray newArray;
            String key = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            JsonArray mergedConditions = new JsonArray();
            if (jsonElement.isJsonPrimitive() && !key.endsWith("/priority")) {
                JsonObject wrappedObject = new JsonObject();
                wrappedObject.add("value", jsonElement);
                JsonArray jsonArray = new JsonArray();
                jsonArray.add((JsonElement)wrappedObject);
                processedJsonObject.add(key, (JsonElement)jsonArray);
                continue;
            }
            if (jsonElement.isJsonArray() && !key.equals(multiListName)) {
                newArray = new JsonArray();
                for (JsonElement arrayElement : jsonElement.getAsJsonArray()) {
                    if (arrayElement.isJsonPrimitive()) {
                        JsonObject wrappedObject = new JsonObject();
                        wrappedObject.add("value", arrayElement);
                        newArray.add((JsonElement)wrappedObject);
                        continue;
                    }
                    newArray.add(arrayElement);
                }
                processedJsonObject.add(key, (JsonElement)newArray);
                continue;
            }
            if (!jsonElement.isJsonObject()) continue;
            newArray = VisionFormatter.wrapObjectInArray(jsonElement, mergedConditions);
            processedJsonObject.add(key, (JsonElement)newArray);
        }
        return processedJsonObject;
    }

    @NotNull
    private static JsonArray wrapObjectInArray(@NotNull JsonElement jsonElement, JsonArray mergedConditions) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonArray newArray = new JsonArray();
        JsonObject newObject = new JsonObject();
        for (Map.Entry objectEntry : jsonObject.entrySet()) {
            String entryKey = (String)objectEntry.getKey();
            JsonElement entryElement = (JsonElement)objectEntry.getValue();
            newObject.add(entryKey, entryElement);
        }
        newObject.add("conditions", (JsonElement)mergedConditions);
        newArray.add((JsonElement)newObject);
        return newArray;
    }

    public static void keyToArray(JsonObject jsonFileObject, String singleName, String listType) {
        JsonArray jsonArray;
        if (!jsonFileObject.has(singleName)) {
            return;
        }
        JsonElement singleElement = jsonFileObject.get(singleName);
        if (!singleElement.isJsonPrimitive()) {
            return;
        }
        Object singleValue = singleElement.getAsString();
        if (singleName.equals("tag") && !((String)singleValue).startsWith("#")) {
            singleValue = "#" + (String)singleValue;
        }
        if (jsonFileObject.has(listType) && jsonFileObject.get(listType).isJsonArray()) {
            jsonArray = jsonFileObject.get(listType).getAsJsonArray();
        } else {
            jsonArray = new JsonArray();
            jsonFileObject.add(listType, (JsonElement)jsonArray);
        }
        jsonFileObject.remove(singleName);
        jsonArray.add((String)singleValue);
    }

    public static ArrayList<String> getEntries(String listName, JsonObject jsonObject) throws JsonParseException {
        if (jsonObject.has(listName)) {
            if (!jsonObject.get(listName).isJsonArray()) {
                throw new JsonParseException(listName + " is not a JsonArray.");
            }
        } else {
            throw new JsonParseException(listName + " not found. " + jsonObject);
        }
        JsonArray listArray = jsonObject.getAsJsonArray(listName);
        return new ArrayList<String>(listArray.asList().stream().map(JsonElement::getAsString).toList());
    }
}

