/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.bans;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.lixir.vminus.VMinus;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class BannedRecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final BannedRecipeManager INSTANCE = new BannedRecipeManager();
    private final Set<ResourceLocation> bannedRecipes = new HashSet<ResourceLocation>();

    private BannedRecipeManager() {
        super(GSON, "bans/recipes");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        File[] jsonFiles;
        this.bannedRecipes.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            this.processJson(entry.getValue().getAsJsonObject());
        }
        File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "bans/recipes");
        if (configDir.exists() && configDir.isDirectory() && (jsonFiles = configDir.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : jsonFiles) {
                try (FileReader reader = new FileReader(file);){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    this.processJson(json);
                }
                catch (Exception e) {
                    VMinus.LOGGER.error("Error reading recipe ban config file '{}':", (Object)file.getName(), (Object)e);
                }
            }
        }
        VMinus.LOGGER.info("Loaded {} banned recipes", (Object)this.bannedRecipes.size());
    }

    private void processJson(@NotNull JsonObject obj) {
        if (!obj.has("banned")) {
            return;
        }
        JsonArray arr = obj.getAsJsonArray("banned");
        for (JsonElement e : arr) {
            this.bannedRecipes.add(new ResourceLocation(e.getAsString()));
        }
    }

    public boolean isBanned(ResourceLocation recipeId) {
        return this.bannedRecipes.contains(recipeId);
    }

    public Set<ResourceLocation> getBannedRecipes() {
        return Collections.unmodifiableSet(this.bannedRecipes);
    }
}

