/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.roles.Role;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class RoleManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static final RoleManager INSTANCE = new RoleManager();
    private final Map<String, Role> roles = new HashMap<String, Role>();

    public RoleManager() {
        super(GSON, "roles");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) throws JsonParseException {
        this.roles.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                String name = jsonObject.get("name").getAsString();
                HashSet<String> commands = new HashSet<String>();
                jsonObject.getAsJsonArray("allowed_commands").forEach(el -> commands.add(el.getAsString()));
                boolean canUseCommandBlocks = jsonObject.has("can_use_command_blocks") && jsonObject.get("can_use_command_blocks").getAsBoolean();
                this.roles.put(name, new Role(name, commands, canUseCommandBlocks));
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
        VMinus.LOGGER.info("Loaded {} roles", (Object)this.roles.size());
    }

    public Set<String> getAllRoleNames() {
        return new HashSet<String>(this.roles.keySet());
    }

    @Nullable
    public Role getRole(String name) {
        return this.roles.get(name);
    }
}

