/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.lixir.vminus.datagen.BlockLootTable;
import net.lixir.vminus.datagen.BlockModel;
import net.lixir.vminus.registry.TintType;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.ItemEntry;
import net.lixir.vminus.registry.entry.RegistryEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BlockEntry
extends RegistryEntry<BlockEntry, Block> {
    public static final BlockEntry EMPTY = BlockEntry.of();
    @NotNull
    protected final Set<TagKey<Block>> tags = new HashSet<TagKey<Block>>();
    @NotNull
    protected String renderType = "unset";
    @NotNull
    protected ItemEntry itemEntry = ItemEntry.of();
    @NotNull
    protected String modelTextureSuffix = "unset";
    @NotNull
    protected TintType tintType = TintType.UNSET;
    @NotNull
    protected BlockModel model = BlockModel.UNSET;
    @NotNull
    protected BlockLootTable lootTable = BlockLootTable.UNSET;
    @NotNull
    protected ResourceLocation modelTextureOverride = UNSET_RESOURCE_LOCATION;
    private boolean isDefaulted = false;

    private BlockEntry() {
    }

    @NotNull
    public static BlockEntry of(@NotNull BlockItem blockItem) {
        return BlockEntry.of(blockItem.m_40614_());
    }

    @NotNull
    public static BlockEntry of(@NotNull Block block) {
        BlockEntry accessed = ((BlockEntryAccessor)block).vminus$getEntry();
        return accessed != null ? accessed : BlockEntry.of();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    @NotNull
    public BlockLootTable getLootTable() {
        return this.lootTable;
    }

    @NotNull
    public BlockEntry lootTable(@NotNull BlockLootTable lootTable) {
        this.lootTable = lootTable;
        return this;
    }

    @NotNull
    public ResourceLocation getModelTextureOverride() {
        return this.modelTextureOverride;
    }

    @Contract(value=" -> new")
    @NotNull
    public static BlockEntry of() {
        return new BlockEntry();
    }

    @NotNull
    public String getModelTextureSuffix() {
        return this.modelTextureSuffix;
    }

    @NotNull
    public static BlockEntry defaults() {
        BlockEntry blockEntry = new BlockEntry();
        blockEntry.isDefaulted = true;
        return blockEntry;
    }

    @Override
    @NotNull
    public BlockEntry setDefault(@NotNull Block block) {
        BlockEntry blockEntry = VRegistry.getBlockEntry(block);
        return this.merge(blockEntry);
    }

    @Override
    @NotNull
    public BlockEntry merge(@Nullable BlockEntry other) {
        if (other == null) {
            return this;
        }
        this.tags.addAll(other.tags);
        this.itemEntry.merge(other.itemEntry);
        if (this.tintType == TintType.UNSET) {
            this.tintType = other.tintType;
        }
        if (this.model == BlockModel.UNSET) {
            this.model = other.model;
        }
        if (this.lootTable == BlockLootTable.UNSET) {
            this.lootTable = other.lootTable;
        }
        if (this.renderType.equals("unset")) {
            this.renderType = other.renderType;
        }
        if (this.modelTextureSuffix.equals("unset")) {
            this.modelTextureSuffix = other.modelTextureSuffix;
        }
        if (this.modelTextureOverride.equals((Object)UNSET_RESOURCE_LOCATION)) {
            this.modelTextureOverride = other.modelTextureOverride;
        }
        return this;
    }

    @NotNull
    public ItemEntry getItemEntry() {
        return this.itemEntry;
    }

    public BlockEntry itemEntry(@NotNull ItemEntry itemEntry) {
        itemEntry.setDefaulted(true);
        this.itemEntry = itemEntry;
        return this;
    }

    @SafeVarargs
    public final BlockEntry tags(TagKey<Block> ... tags) {
        if (BlockEntry.isDatagen()) {
            this.tags.addAll(Arrays.asList(tags));
        }
        return this;
    }

    @NotNull
    public Set<TagKey<Block>> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public BlockEntry modelTextureOverride(@NotNull ResourceLocation modelTextureOverride) {
        if (BlockEntry.isDatagen()) {
            this.modelTextureOverride = modelTextureOverride;
        }
        return this;
    }

    public BlockEntry modelTextureSuffix(@NotNull String modelTextureSuffix) {
        if (BlockEntry.isDatagen()) {
            this.modelTextureSuffix = modelTextureSuffix;
        }
        return this;
    }

    public BlockEntry renderType(@NotNull String renderType) {
        this.renderType = renderType;
        return this;
    }

    public BlockEntry tintType(@NotNull TintType tintType) {
        this.tintType = tintType;
        return this;
    }

    public BlockEntry model(@NotNull BlockModel model) {
        if (BlockEntry.isDatagen()) {
            this.model = model;
        }
        return this;
    }

    @NotNull
    public String getRenderType() {
        return this.renderType;
    }

    @NotNull
    public TintType getTintType() {
        return this.tintType;
    }

    @NotNull
    public BlockModel getModel() {
        return this.model;
    }

    @Override
    public BlockEntry lang(String langValue) {
        if (BlockEntry.isDatagen()) {
            this.lang = langValue;
        }
        return this;
    }

    @Override
    public boolean isDefaulted() {
        return this.isDefaulted;
    }

    public String toString() {
        return "BlockEntry{tags=" + this.tags + ", renderType='" + this.renderType + "', itemEntry=" + this.itemEntry + ", modelTextureSuffix='" + this.modelTextureSuffix + "', tintType=" + this.tintType + ", model=" + this.model + ", lootTable=" + this.lootTable + ", modelTextureOverride=" + this.modelTextureOverride + ", isDefaulted=" + this.isDefaulted + ", langValue='" + this.lang + "'}";
    }
}

