/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.datagen.SoundDefinitionInfo;
import net.lixir.vminus.registry.entry.BlockEntry;
import net.lixir.vminus.registry.entry.EntityEntry;
import net.lixir.vminus.registry.entry.ItemEntry;
import net.lixir.vminus.registry.entry.RegistryEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.lixir.vminus.registry.entry.accessor.EntityEntryAccessor;
import net.lixir.vminus.registry.entry.accessor.ItemEntryAccessor;
import net.lixir.vminus.registry.entry.group.RegistryEntryGroup;
import net.lixir.vminus.registry.entry.group.RegistryEntryGroupsProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VRegistry {
    private static final ConcurrentHashMap<String, VRegistry> REGISTRIES = new ConcurrentHashMap();
    private final NonNullList<Block> blocks = NonNullList.m_122779_();
    private final NonNullList<EntityType<?>> entityTypes = NonNullList.m_122779_();
    private final NonNullList<SoundEvent> soundEvents = NonNullList.m_122779_();
    private final NonNullList<Item> items = NonNullList.m_122779_();
    private final NonNullList<SoundDefinitionInfo> soundDefinitionInfo = NonNullList.m_122779_();
    private final NonNullList<Fluid> fluids = NonNullList.m_122779_();
    private final String modId;

    private VRegistry(String modId) {
        this.modId = modId;
    }

    @Nullable
    public static <E extends RegistryEntry<E, T>, T> RegistryEntry<E, T> getRegistryEntry(@NotNull T targetObject) {
        Class<?> targetClass = targetObject.getClass();
        ArrayList<RegistryEntryGroup> compatibleGroups = new ArrayList<RegistryEntryGroup>();
        RegistryEntryGroup<?> bestGroup = null;
        int bestDistance = Integer.MAX_VALUE;
        HashMap groupDistances = new HashMap();
        for (Map.Entry<Class<?>, RegistryEntryGroup<?>> entry : RegistryEntryGroupsProvider.getAssignedEntries().entrySet()) {
            Class<?> groupClass = entry.getKey();
            if (!groupClass.isAssignableFrom(targetClass)) continue;
            RegistryEntryGroup<?> group = entry.getValue();
            compatibleGroups.add(group);
            int distance = VRegistry.getClassDistance(targetClass, groupClass);
            groupDistances.put(group, distance);
            if (distance >= bestDistance) continue;
            bestDistance = distance;
            bestGroup = group;
        }
        for (Map.Entry<Object, RegistryEntryGroup<?>> entry : RegistryEntryGroupsProvider.getAssignedSuppliers().entrySet()) {
            Object supplied = ((Supplier)entry.getKey()).get();
            if (!targetObject.equals(supplied)) continue;
            bestGroup = entry.getValue();
            break;
        }
        compatibleGroups.remove(bestGroup);
        if (bestGroup != null) {
            RegistryEntry bestEntry = bestGroup.getEntry();
            compatibleGroups.sort(Comparator.comparingInt(g -> groupDistances.getOrDefault(g, Integer.MAX_VALUE)));
            for (RegistryEntryGroup group : compatibleGroups) {
                RegistryEntry otherEntry = group.getEntry();
                bestEntry.merge(otherEntry);
            }
            return bestEntry;
        }
        return null;
    }

    private static int getClassDistance(Class<?> child, Class<?> parent) {
        int distance = 0;
        while (child != null && !child.equals(parent)) {
            child = child.getSuperclass();
            ++distance;
        }
        return child == null ? Integer.MAX_VALUE : distance;
    }

    @Nullable
    public static ItemEntry getItemEntry(Item item) {
        RegistryEntry entry = VRegistry.getRegistryEntry(item);
        return entry instanceof ItemEntry ? (ItemEntry)entry : null;
    }

    @Nullable
    public static BlockEntry getBlockEntry(Block block) {
        RegistryEntry entry = VRegistry.getRegistryEntry(block);
        return entry instanceof BlockEntry ? (BlockEntry)entry : null;
    }

    @NotNull
    public static List<VRegistry> getRegistries() {
        return REGISTRIES.values().stream().toList();
    }

    public static VRegistry fromId(String id) {
        return REGISTRIES.get(id);
    }

    @NotNull
    public static VRegistry create(String modId, @Nullable RegistryEntryGroupsProvider registryEntryGroupsProvider) {
        VRegistry registry = new VRegistry(modId);
        if (REGISTRIES.putIfAbsent(modId, registry) != null) {
            throw new IllegalStateException("UnifiedRegistry already exists for mod ID: " + modId);
        }
        if (registryEntryGroupsProvider != null) {
            registryEntryGroupsProvider.run();
        }
        return registry;
    }

    public List<Fluid> getFluids() {
        return this.fluids;
    }

    public <T extends Fluid> T fluid(@NotNull String name, @NotNull T fluid) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name);
        Fluid registered = (Fluid)Registry.m_122965_((Registry)BuiltInRegistries.f_257020_, (ResourceLocation)location, fluid);
        this.fluids.add((Object)registered);
        return (T)registered;
    }

    public List<SoundEvent> getSoundEvents() {
        return this.soundEvents;
    }

    public List<SoundDefinitionInfo> getSoundDefinitionInfo() {
        return this.soundDefinitionInfo;
    }

    public String getModId() {
        return this.modId;
    }

    public Block block(@NotNull String name, @NotNull Block block) {
        return this.block(name, block, BlockEntry.defaults());
    }

    public Item blockItem(@NotNull Block block) {
        return this.blockItem(null, block, new BlockItem(block, new Item.Properties()), ItemEntry.from(block));
    }

    public Item blockItem(@NotNull Block block, @NotNull BlockItem blockItem) {
        return this.blockItem(null, block, blockItem, ItemEntry.from(block));
    }

    public Item blockItem(@NotNull Block block, @NotNull BlockItem blockItem, @NotNull ItemEntry itemEntry) {
        return this.blockItem(null, block, blockItem, itemEntry);
    }

    public Item blockItem(@Nullable String name, @NotNull Block block, @NotNull BlockItem blockItem, @NotNull ItemEntry itemEntry) {
        if (name == null) {
            ResourceLocation blockKey = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            name = blockKey.m_135815_();
        }
        return this.item(name, (Item)blockItem, itemEntry.merge(ItemEntry.from(block)));
    }

    public Item blockItem(@NotNull Block block, @NotNull ItemEntry itemEntry) {
        return this.blockItem(null, block, new BlockItem(block, new Item.Properties()), itemEntry);
    }

    public Item blockItem(@NotNull String name, @NotNull Block block) {
        return this.blockItem(name, block, new BlockItem(block, new Item.Properties()), ItemEntry.from(block));
    }

    public Item blockItem(@NotNull String name, @NotNull Block block, @NotNull ItemEntry itemEntry) {
        return this.blockItem(name, block, new BlockItem(block, new Item.Properties()), itemEntry);
    }

    public Item blockItem(@NotNull BlockItem blockItem) {
        Block block = blockItem.m_40614_();
        return this.blockItem(null, block, blockItem, ItemEntry.from(block));
    }

    public Item blockItem(@NotNull BlockItem blockItem, @NotNull ItemEntry itemEntry) {
        Block block = blockItem.m_40614_();
        return this.blockItem(null, block, blockItem, itemEntry);
    }

    public Block block(@NotNull String name, @NotNull Block block, @NotNull BlockEntry blockEntry) {
        BlockEntryAccessor accessor = (BlockEntryAccessor)block;
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name);
        Block registered = (Block)Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)resourceLocation, (Object)block);
        this.blocks.add((Object)registered);
        accessor.vminus$setEntry(blockEntry);
        if (blockEntry.isDefaulted()) {
            blockEntry.setDefault(registered);
        }
        VMinus.LOGGER.debug("Final Registered entry({}) for {}", (Object)accessor.vminus$getEntry(), (Object)name);
        return registered;
    }

    public Item item(@NotNull String name) {
        return this.item(name, new Item(new Item.Properties()), ItemEntry.defaults());
    }

    public Item item(@NotNull String name, @NotNull Item item) {
        return this.item(name, item, ItemEntry.defaults());
    }

    public Item item(@NotNull String name, @NotNull ItemEntry itemEntry) {
        return this.item(name, new Item(new Item.Properties()), itemEntry);
    }

    public Item item(@NotNull String name, @NotNull Item item, @NotNull ItemEntry itemEntry) {
        ItemEntryAccessor accessor = (ItemEntryAccessor)item;
        Item registered = (Item)Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)item);
        this.items.add((Object)registered);
        accessor.vminus$setEntry(itemEntry);
        if (itemEntry.isDefaulted()) {
            itemEntry.setDefault(registered);
        }
        if (registered instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)registered;
            blockItem.m_6192_(Item.f_41373_, registered);
        }
        return registered;
    }

    public MobEffect effect(@NotNull String name, @NotNull MobEffect mobEffect) {
        return (MobEffect)Registry.m_122965_((Registry)BuiltInRegistries.f_256974_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)mobEffect);
    }

    public <T extends Entity> EntityType<T> entity(@NotNull String name, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull EntityType.Builder<T> entityTypeBuilder) {
        return this.entity(name, entityTypeBuilder, null);
    }

    public <T extends Entity> EntityType<T> entity(@NotNull String name, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull EntityType.Builder<T> entityTypeBuilder, @Nullable EntityEntry entityEntry) {
        EntityType entityType = (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)entityTypeBuilder.m_20712_(name));
        EntityEntryAccessor accessor = (EntityEntryAccessor)entityType;
        if (entityEntry == null) {
            entityEntry = EntityEntry.of();
        }
        accessor.vminus$setEntry(entityEntry);
        this.entityTypes.add((Object)entityType);
        return entityType;
    }

    public CreativeModeTab tab(@NotNull String name, @NotNull CreativeModeTab creativeModeTab) {
        return (CreativeModeTab)Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)creativeModeTab);
    }

    public Feature<?> feature(@NotNull String name, @NotNull Feature<?> feature) {
        return (Feature)Registry.m_122965_((Registry)BuiltInRegistries.f_256810_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), feature);
    }

    public <T extends FoliagePlacer> FoliagePlacerType<T> foliagePlacer(@NotNull String name, @NotNull FoliagePlacerType<T> foliagePlacerType) {
        return (FoliagePlacerType)Registry.m_122965_((Registry)BuiltInRegistries.f_256861_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), foliagePlacerType);
    }

    public <T extends TrunkPlacer> TrunkPlacerType<T> trunkPlacer(@NotNull String name, @NotNull TrunkPlacerType<T> trunkPlacerType) {
        return (TrunkPlacerType)Registry.m_122965_((Registry)BuiltInRegistries.f_256920_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), trunkPlacerType);
    }

    public PaintingVariant painting(@NotNull String name, int width, int height) {
        return this.painting(name, new PaintingVariant(width * 16, height * 16));
    }

    public Attribute attribute(@NotNull String name, @NotNull Attribute attribute) {
        return (Attribute)Registry.m_122965_((Registry)BuiltInRegistries.f_256951_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)attribute);
    }

    public Attribute attribute(@NotNull String name, double defaultValue, double minimumValue, double maximumValue) {
        return (Attribute)Registry.m_122965_((Registry)BuiltInRegistries.f_256951_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)new RangedAttribute("attribute." + this.modId + ".name." + name, defaultValue, minimumValue, maximumValue).m_22084_(true));
    }

    public PaintingVariant painting(@NotNull String name, @NotNull PaintingVariant paintingVariant) {
        return (PaintingVariant)Registry.m_122965_((Registry)BuiltInRegistries.f_257051_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)paintingVariant);
    }

    public <T extends BlockEntity> BlockEntityType<T> blockEntity(@NotNull String name, @NotNull BlockEntityType<T> type) {
        return (BlockEntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_257049_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), type);
    }

    public Item dye(@NotNull String id, @NotNull DyeColor dyeColor) {
        return this.item(id, (Item)new DyeItem(dyeColor, new Item.Properties()));
    }

    public <T extends BlockEntity> BlockEntityType<T> blockEntity(@NotNull String name, @NotNull BlockEntityType.BlockEntitySupplier<T> factory, Block ... blocks) {
        return (BlockEntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_257049_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)BlockEntityType.Builder.m_155273_(factory, (Block[])blocks).m_58966_(null));
    }

    public SoundEvent sound(@NotNull String name, String eventPath) {
        return this.sound(name, SoundDefinitionInfo.of(eventPath));
    }

    public SoundEvent sound(@NotNull String name, @NotNull SoundDefinitionInfo soundDefinitionInfo) {
        SoundEvent soundEvent = (SoundEvent)Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.modId, name)));
        this.soundDefinitionInfo.add((Object)soundDefinitionInfo.setSoundEvent(soundEvent));
        return soundEvent;
    }

    public Holder.Reference<SoundEvent> soundHolder(@NotNull String name, @NotNull SoundDefinitionInfo soundDefinitionInfo) {
        SoundEvent soundEvent = (SoundEvent)Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), (Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(this.modId, name)));
        this.soundDefinitionInfo.add((Object)soundDefinitionInfo.setSoundEvent(soundEvent));
        return (Holder.Reference)BuiltInRegistries.f_256894_.m_203636_((ResourceKey)BuiltInRegistries.f_256894_.m_7854_((Object)soundEvent).orElseThrow()).orElseThrow();
    }

    public <T extends ParticleOptions> ParticleType<T> particle(@NotNull String name, @NotNull ParticleType<T> particleType) {
        return (ParticleType)Registry.m_122965_((Registry)BuiltInRegistries.f_257034_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), particleType);
    }

    public <T extends TreeDecorator> TreeDecoratorType<T> treeDecorator(@NotNull String name, @NotNull TreeDecoratorType<T> treeDecoratorType) {
        return (TreeDecoratorType)Registry.m_122965_((Registry)BuiltInRegistries.f_256987_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), treeDecoratorType);
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public List<EntityType<?>> getEntityTypes() {
        return Collections.unmodifiableList(this.entityTypes);
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public List<Pair<Item, ItemEntry>> getItemEntryPairs() {
        return this.items.stream().map(item -> new Pair(item, (Object)ItemEntry.of(item))).filter(entry -> !((ItemEntry)entry.getSecond()).isEmpty()).toList();
    }
}

