/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.lixir.vminus.network.SyncCapePacketHandler;
import net.lixir.vminus.network.VMinusNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public record SyncCapePacket(UUID playerUUID, String capeId) {
    public static void encode(@NotNull SyncCapePacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerUUID);
        buf.m_130070_(msg.capeId);
    }

    @NotNull
    public static SyncCapePacket decode(@NotNull FriendlyByteBuf buf) {
        UUID playerUUID = buf.m_130259_();
        String capeId = buf.m_130277_();
        return new SyncCapePacket(playerUUID, capeId);
    }

    public static void handle(SyncCapePacket msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                SyncCapePacketHandler.handle(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void sendTo(ServerPlayer target, UUID player, String capeId) {
        VMinusNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new SyncCapePacket(player, capeId));
    }

    public static void sendToAll(@NotNull ServerPlayer sourcePlayer, String capeId) {
        SyncCapePacket packet = new SyncCapePacket(sourcePlayer.m_20148_(), capeId);
        VMinusNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }
}

