/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.network;

import java.util.function.Supplier;
import net.lixir.vminus.item.IEquipmentItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ServerboundJumpPacket {
    private final int entityId;
    private final boolean onGround;

    public ServerboundJumpPacket(int entityId, boolean onGround) {
        this.entityId = entityId;
        this.onGround = onGround;
    }

    public static void encode(@NotNull ServerboundJumpPacket pkt, @NotNull FriendlyByteBuf buf) {
        buf.writeInt(pkt.entityId);
        buf.writeBoolean(pkt.onGround);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ServerboundJumpPacket decode(@NotNull FriendlyByteBuf buf) {
        return new ServerboundJumpPacket(buf.readInt(), buf.readBoolean());
    }

    public static void handle(ServerboundJumpPacket pkt, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.m_284548_();
            Entity entity = level.m_6815_(pkt.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack boots = livingEntity.m_6844_(EquipmentSlot.FEET);
            if (boots.m_41619_()) {
                return;
            }
            Item patt1826$temp = boots.m_41720_();
            if (patt1826$temp instanceof IEquipmentItem) {
                IEquipmentItem IEquipmentItem2 = (IEquipmentItem)patt1826$temp;
                IEquipmentItem2.onEntityJump((Level)level, livingEntity, boots, pkt.onGround);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

