/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.world.inventory;

import net.lixir.vminus.mixins.world.inventory.SlotAccessor;
import net.lixir.vminus.vision.util.ItemReplacement;
import net.lixir.vminus.vision.util.VisionUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slot.class})
public abstract class SlotMixin {
    @Unique
    private final Slot vminus$slot = (Slot)this;

    @Shadow
    public abstract ItemStack m_7993_();

    @Shadow
    public abstract void m_6654_();

    @Inject(method={"hasItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$preventBannedItemTake(CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = this.m_7993_();
        if (VisionUtils.isBanned(stack)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"mayPlace"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$preventBannedItemTake(@NotNull ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (VisionUtils.isBanned(stack)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"mayPickup"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$preventBannedItemTake(Player player, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = this.m_7993_();
        if (VisionUtils.isBanned(stack)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")}, cancellable=true)
    private void vMinus$preventBannedItemTake(Player player, @NotNull ItemStack stack, CallbackInfo ci) {
        if (VisionUtils.isBanned(stack)) {
            this.m_6654_();
            ci.cancel();
        }
    }

    @Inject(method={"set"}, at={@At(value="HEAD")}, cancellable=true)
    private void vMinus$set(@NotNull ItemStack itemStack, CallbackInfo ci) {
        SlotAccessor slotAccessor = (SlotAccessor)this.vminus$slot;
        if (ItemReplacement.tryReplace(itemStack, replaced -> this.vminus$slot.f_40218_.m_6836_(slotAccessor.getSlot(), replaced))) {
            this.m_6654_();
            ci.cancel();
        }
    }
}

