/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.items;

import net.lixir.vminus.item.IMaxDurationGetter;
import net.lixir.vminus.registry.entry.ItemEntry;
import net.lixir.vminus.registry.entry.accessor.ItemEntryAccessor;
import net.lixir.vminus.util.FoodPropertiesUtil;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.lixir.vminus.vision.util.ItemStackWrapper;
import net.lixir.vminus.vision.util.VisionFoodProperties;
import net.lixir.vminus.vision.util.VisionUtils;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin
implements VisionDuck,
ItemEntryAccessor,
IMaxDurationGetter,
IForgeItem {
    @Unique
    private final Item vMinus$self = (Item)this;
    @Unique
    private ItemEntry vMinus$itemEntry = null;
    @Unique
    private ResourceLocation vMinus$visionId = null;

    @Inject(method={"finishUsingItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$finishUsingItem(@NotNull ItemStack itemStack, Level p_40685_, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        ItemStackWrapper useRemainder = VisionUtils.getOverrideValue(this, VisionProperties.Items.USE_REMAINDER, new VisionContext(this.vMinus$self));
        if (useRemainder == null) {
            return;
        }
        ItemStack useRemainderStack = useRemainder.itemStack();
        if (useRemainderStack.m_41619_()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_ && !player.m_150109_().m_36054_(useRemainderStack)) {
                player.m_36176_(useRemainderStack, false);
            }
        }
        cir.setReturnValue((Object)itemStack);
    }

    @Inject(method={"isFoil"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$isFoil(CallbackInfoReturnable<Boolean> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.GLINT, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getMaxStackSize"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getMaxStackSize(CallbackInfoReturnable<Integer> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.MAX_STACK_SIZE, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getMaxDamage(CallbackInfoReturnable<Integer> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.MAX_DAMAGE, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"canBeDepleted"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$canBeDepleted(CallbackInfoReturnable<Boolean> cir) {
        Integer maxDamage = VisionUtils.getOverrideValue(this, VisionProperties.Items.MAX_DAMAGE, new VisionContext(this.vMinus$self));
        if (maxDamage != null && maxDamage > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getUseAnimation"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getUseAnimation(ItemStack itemStack, CallbackInfoReturnable<UseAnim> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.USE_ANIMATION, new VisionContext(itemStack));
    }

    @Inject(method={"getFoodProperties"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getFoodProperties(CallbackInfoReturnable<FoodProperties> cir) {
        VisionFoodProperties visionFoodProperties = VisionUtils.getOverrideValue(this, VisionProperties.Items.FOOD, new VisionContext(this.vMinus$self));
        if (visionFoodProperties != null) {
            cir.setReturnValue((Object)FoodPropertiesUtil.merge((FoodProperties)cir.getReturnValue(), visionFoodProperties));
        }
    }

    @Inject(method={"isFireResistant"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$isFireResistant(CallbackInfoReturnable<Boolean> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.FIRE_RESISTANT, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getUseDuration"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getUseDuration(ItemStack itemStack, CallbackInfoReturnable<Integer> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.USE_TICKS, new VisionContext(itemStack));
    }

    @Inject(method={"isEdible"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$isEdible(CallbackInfoReturnable<Boolean> cir) {
        VisionFoodProperties visionFoodProperties = VisionUtils.getOverrideValue(this, VisionProperties.Items.FOOD, new VisionContext(this.vMinus$self));
        if (visionFoodProperties != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getEnchantmentValue"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getEnchantmentValue(CallbackInfoReturnable<Integer> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.ENCHANTABILITY, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getRarity"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getRarity(ItemStack itemStack, CallbackInfoReturnable<Rarity> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Items.RARITY, new VisionContext(itemStack));
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        Integer value = VisionUtils.getOverrideValue(this, VisionProperties.Items.FUEL_TICKS, new VisionContext(stack));
        if (value != null) {
            return value;
        }
        return super.getBurnTime(stack, recipeType);
    }

    @Override
    public void vminus$setEntry(ItemEntry itemEntry) {
        this.vMinus$itemEntry = itemEntry;
    }

    @Override
    @Nullable
    public ItemEntry vminus$getEntry() {
        return this.vMinus$itemEntry;
    }

    @Override
    public int vminus$getMaxDuration() {
        Integer value = VisionUtils.getOverrideValue(this, VisionProperties.Items.MAX_USE_TICKS, new VisionContext(this.vMinus$self));
        if (value != null) {
            return value;
        }
        return 0;
    }

    public EquipmentSlot getEquipmentSlot(ItemStack self) {
        EquipmentSlot equipmentSlot = VisionUtils.getOverrideValue(this, VisionProperties.Items.EQUIP_SLOT, new VisionContext(self));
        if (equipmentSlot != null) {
            return equipmentSlot;
        }
        return super.getEquipmentSlot(self);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        Boolean canEquip = VisionUtils.getOverrideValue(this, VisionProperties.Items.CAN_EQUIP, new VisionContext(stack));
        if (canEquip != null) {
            return canEquip;
        }
        EquipmentSlot equipmentSlot = VisionUtils.getOverrideValue(this, VisionProperties.Items.EQUIP_SLOT, new VisionContext(stack));
        if (equipmentSlot != null) {
            return true;
        }
        return super.canEquip(stack, armorType, entity);
    }

    @Override
    public @NonNull VisionType<?> vMinus$getVisionType() {
        return VisionTypes.ITEM;
    }

    @Override
    public void vMinus$setVisionId(ResourceLocation id) {
        this.vMinus$visionId = id;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVisionId() {
        return this.vMinus$visionId;
    }
}

