/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.data.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.lixir.vminus.mixins.data.recipe.RecipeManagerAccessor;
import net.lixir.vminus.resources.data.RegistryAccessHolder;
import net.lixir.vminus.vision.util.VisionUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin
extends SimpleJsonResourceReloadListener
implements RegistryAccessHolder {
    @Shadow
    @Mutable
    private Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> f_44007_;
    @Shadow
    @Mutable
    private Map<ResourceLocation, Recipe<?>> f_199900_;
    @Unique
    private RegistryAccess.Frozen vMinus$registryAccess;

    public RecipeManagerMixin(Gson p_10768_, String p_10769_) {
        super(p_10768_, p_10769_);
    }

    @Override
    public RegistryAccess.Frozen vMinus$getRegistryAccess() {
        return this.vMinus$registryAccess;
    }

    @Override
    public void vMinus$setRegistryAccess(RegistryAccess.Frozen access) {
        this.vMinus$registryAccess = access;
    }

    @Inject(method={"createCheck"}, at={@At(value="RETURN")}, cancellable=true)
    private static <C extends Container, T extends Recipe<C>> void vminus$filterBannedRecipes(RecipeType<T> type, @NotNull CallbackInfoReturnable<RecipeManager.CachedCheck<C, T>> cir) {
        final RecipeManager.CachedCheck originalCheck = (RecipeManager.CachedCheck)cir.getReturnValue();
        cir.setReturnValue((Object)new RecipeManager.CachedCheck<C, T>(){

            @NotNull
            public Optional<T> m_213657_(@NotNull C container, @NotNull Level level) {
                Optional recipeOpt = originalCheck.m_213657_(container, level);
                return recipeOpt.filter(recipe -> {
                    ItemStack result = recipe.m_8043_(level.m_9598_());
                    return !VisionUtils.isBanned(result);
                });
            }
        });
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends Container, T extends Recipe<C>> void vminus$filterBannedRecipe(RecipeType<T> type, C container, Level level, CallbackInfoReturnable<Optional<T>> cir) {
        Map<ResourceLocation, T> recipeMap = ((RecipeManagerAccessor)((Object)this)).vminus$getByType(type);
        for (Recipe recipe : recipeMap.values()) {
            ItemStack result;
            if (!recipe.m_5818_(container, level) || !VisionUtils.isBanned(result = recipe.m_8043_(level.m_9598_()))) continue;
            cir.setReturnValue(Optional.empty());
            return;
        }
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="TAIL")})
    private void vminus$filterBannedRecipes(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager resourceManager, ProfilerFiller p_44039_, CallbackInfo ci) {
        Predicate<Map.Entry> recipeFilter = e -> !VisionUtils.isRecipeBanned((Recipe)e.getValue(), (ResourceLocation)e.getKey(), (RegistryAccess)this.vMinus$registryAccess);
        HashMap filtered = new HashMap();
        for (Map.Entry<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> entry : this.f_44007_.entrySet()) {
            Map<ResourceLocation, Recipe> typeMap = entry.getValue().entrySet().stream().filter(recipeFilter).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            filtered.put(entry.getKey(), typeMap);
        }
        this.f_44007_ = filtered;
        this.f_199900_ = this.f_199900_.entrySet().stream().filter(recipeFilter).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/Container;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private <C extends Container, T extends Recipe<C>> void vminus$filterBannedRecipeById(RecipeType<T> type, C container, Level level, ResourceLocation id, CallbackInfoReturnable<Optional<Pair<ResourceLocation, T>>> cir) {
        ItemStack result;
        Recipe recipe;
        Map<ResourceLocation, T> recipeMap = ((RecipeManagerAccessor)((Object)this)).vminus$getByType(type);
        if (id != null && (recipe = (Recipe)recipeMap.get(id)) != null && recipe.m_5818_(container, level) && !VisionUtils.isBanned(result = recipe.m_8043_(level.m_9598_()))) {
            cir.setReturnValue(Optional.of(Pair.of((Object)id, (Object)recipe)));
            return;
        }
        for (Map.Entry<ResourceLocation, T> entry : recipeMap.entrySet()) {
            ItemStack result2;
            Recipe recipe2 = (Recipe)entry.getValue();
            if (!recipe2.m_5818_(container, level) || VisionUtils.isBanned(result2 = recipe2.m_8043_(level.m_9598_()))) continue;
            cir.setReturnValue(Optional.of(Pair.of((Object)entry.getKey(), (Object)recipe2)));
            return;
        }
        cir.setReturnValue(Optional.empty());
    }
}

