/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.block;

import net.lixir.vminus.registry.entry.BlockEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.VisionType;
import net.lixir.vminus.vision.VisionTypes;
import net.lixir.vminus.vision.util.VisionUtils;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin
implements VisionDuck,
BlockEntryAccessor {
    @Unique
    private final Block vMinus$self = (Block)this;
    @Unique
    private BlockEntry vMinus$blockEntry = null;
    @Unique
    private ResourceLocation vMinus$visionId = null;

    @Inject(method={"getSpeedFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getSpeedFactor(CallbackInfoReturnable<Float> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Blocks.SPEED_FACTOR, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getFriction"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getFriction(CallbackInfoReturnable<Float> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Blocks.FRICTION, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getJumpFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getJumpFactor(CallbackInfoReturnable<Float> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Blocks.JUMP_FACTOR, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getExplosionResistance"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getExplosionResistance(CallbackInfoReturnable<Float> cir) {
        VisionUtils.tryOverride(cir, this, VisionProperties.Blocks.BLAST_RESISTANCE, new VisionContext(this.vMinus$self));
    }

    @Inject(method={"getSoundType"}, at={@At(value="RETURN")}, cancellable=true)
    private void vMinus$getSoundType(BlockState state, @NotNull CallbackInfoReturnable<SoundType> cir) {
        SoundType original = (SoundType)cir.getReturnValue();
        SoundType override = VisionUtils.getOverrideValue(this, VisionProperties.Blocks.SOUND, new VisionContext(this.vMinus$self));
        if (override != null) {
            float volume = override.m_56773_() != 0.0f ? override.m_56773_() : original.m_56773_();
            float pitch = override.m_56774_() != 0.0f ? override.m_56774_() : original.m_56774_();
            cir.setReturnValue((Object)new SoundType(volume, pitch, override.m_56775_(), override.m_56776_(), override.m_56777_(), override.m_56778_(), override.m_56779_()));
        }
    }

    @Override
    public void vminus$setEntry(BlockEntry blockEntry) {
        this.vMinus$blockEntry = blockEntry;
    }

    @Override
    public BlockEntry vminus$getEntry() {
        return this.vMinus$blockEntry;
    }

    @Override
    public void vMinus$setVisionId(ResourceLocation id) {
        this.vMinus$visionId = id;
    }

    @Override
    @Nullable
    public ResourceLocation vMinus$getVisionId() {
        return this.vMinus$visionId;
    }

    @Override
    public @NonNull VisionType<?> vMinus$getVisionType() {
        return VisionTypes.BLOCK;
    }
}

