/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events.resource;

import com.mojang.datafixers.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lixir.vminus.network.ClientboundSightSyncPacket;
import net.lixir.vminus.network.VMinusNetwork;
import net.lixir.vminus.network.vision.ClientboundDataResetPacket;
import net.lixir.vminus.network.vision.ClientboundVisionListPacket;
import net.lixir.vminus.resources.data.sight.SightManager;
import net.lixir.vminus.resources.data.vision.VisionManager;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class OnDatapackSyncEventHandler {
    public static final int MAX_PACKET_SIZE = 30000;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onDatapackSync(@NotNull OnDatapackSyncEvent event) {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        ServerPlayer dedicatedPlayer = event.getPlayer();
        if (dedicatedPlayer != null) {
            if (dedicatedPlayer.m_9236_().f_46443_) {
                return;
            }
            players.add(dedicatedPlayer);
            if (!dedicatedPlayer.f_8924_.m_6982_()) {
                return;
            }
        } else {
            players.addAll(event.getPlayers());
        }
        for (ServerPlayer player : players) {
            VMinusNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundDataResetPacket());
            VMinusNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSightSyncPacket(SightManager.getAllSights()));
            for (VisionManager<?> visionManager : List.copyOf(VisionManager.getVisionManagers())) {
                VisionType<?> visionType = visionManager.getVisionType();
                HashMap<CompoundTag, ArrayList<ResourceLocation>> grouped = new HashMap<CompoundTag, ArrayList<ResourceLocation>>();
                ArrayList<CompoundTag> existingTags = new ArrayList<CompoundTag>();
                for (Map.Entry<ResourceLocation, Vision> entry : List.copyOf(visionManager.getVisionEntries())) {
                    ResourceLocation id = entry.getKey();
                    Vision vision = entry.getValue();
                    CompoundTag tag = vision.encode(visionType);
                    CompoundTag match = null;
                    for (CompoundTag existing : existingTags) {
                        if (!existing.equals((Object)tag)) continue;
                        match = existing;
                        break;
                    }
                    if (match != null) {
                        ((List)grouped.get(match)).add(id);
                        continue;
                    }
                    grouped.put(tag, new ArrayList<ResourceLocation>(List.of(id)));
                    existingTags.add(tag);
                }
                ArrayList<Pair<List<ResourceLocation>, CompoundTag>> groupedPairs = new ArrayList<Pair<List<ResourceLocation>, CompoundTag>>();
                for (Map.Entry entry3 : grouped.entrySet()) {
                    groupedPairs.add((Pair<List<ResourceLocation>, CompoundTag>)Pair.of((Object)((List)entry3.getValue()), (Object)((CompoundTag)entry3.getKey())));
                }
                List<List<Pair<List<ResourceLocation>, CompoundTag>>> list = OnDatapackSyncEventHandler.splitGrouped(groupedPairs);
                int i = 0;
                for (List<Pair<List<ResourceLocation>, CompoundTag>> chunk : list) {
                    ClientboundVisionListPacket packet = new ClientboundVisionListPacket(visionType.getId(), chunk);
                    VMinusNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                    ++i;
                }
            }
        }
    }

    @NotNull
    private static List<List<Pair<List<ResourceLocation>, CompoundTag>>> splitGrouped(@NotNull List<Pair<List<ResourceLocation>, CompoundTag>> all) {
        ArrayList<List<Pair<List<ResourceLocation>, CompoundTag>>> chunks = new ArrayList<List<Pair<List<ResourceLocation>, CompoundTag>>>();
        ArrayList<Pair<List<ResourceLocation>, CompoundTag>> current = new ArrayList<Pair<List<ResourceLocation>, CompoundTag>>();
        int size = 0;
        for (Pair<List<ResourceLocation>, CompoundTag> pair : all) {
            int entrySize = OnDatapackSyncEventHandler.getGroupedVisionEntrySize(pair);
            if (size + entrySize > 30000 && !current.isEmpty()) {
                chunks.add(current);
                current = new ArrayList();
                size = 0;
            }
            current.add(pair);
            size += entrySize;
        }
        if (!current.isEmpty()) {
            chunks.add(current);
        }
        return chunks;
    }

    private static int getGroupedVisionEntrySize(@NotNull Pair<List<ResourceLocation>, CompoundTag> pair) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            NbtIo.m_128947_((CompoundTag)((CompoundTag)pair.getSecond()), (OutputStream)baos);
            baos.flush();
            int tagSize = baos.size();
            int idsSize = 0;
            idsSize += FriendlyByteBuf.m_130053_((int)((List)pair.getFirst()).size());
            for (ResourceLocation id : (List)pair.getFirst()) {
                String full = id.toString();
                idsSize += FriendlyByteBuf.m_130053_((int)full.length());
                idsSize += full.getBytes(StandardCharsets.UTF_8).length;
            }
            return idsSize + tagSize;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

