/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events.item;

import com.google.common.collect.Multimap;
import java.util.List;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionProperties;
import net.lixir.vminus.vision.util.VisionAttribute;
import net.lixir.vminus.vision.values.conditions.VisionContext;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class ItemAttributeEventHandler {
    @SubscribeEvent
    public static void addAttributeModifier(@NotNull ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        EquipmentSlot eventSlot = event.getSlotType();
        Vision vision = Vision.get((VisionDuck)item);
        List<VisionAttribute> visionAttributes = vision.getValues(VisionProperties.Items.ATTRIBUTE, new VisionContext(itemStack));
        for (VisionAttribute visionAttribute : visionAttributes) {
            boolean replace = visionAttribute.replace();
            boolean remove = visionAttribute.remove();
            if (!replace && !remove) continue;
            Multimap originalModifiers = event.getOriginalModifiers();
            for (Attribute a : originalModifiers.keySet()) {
                for (AttributeModifier modifier : originalModifiers.get((Object)a)) {
                    String modifierId = BuiltInRegistries.f_256951_.m_7981_((Object)a).toString();
                    if (!modifierId.equals(visionAttribute.id())) continue;
                    event.removeModifier(a, modifier);
                }
            }
        }
        for (VisionAttribute visionAttribute : visionAttributes) {
            boolean remove = visionAttribute.remove();
            if (remove) continue;
            EquipmentSlot equipmentSlot = visionAttribute.equipmentSlot();
            if (equipmentSlot == null) {
                if (item instanceof Equipable) {
                    Equipable equipable = (Equipable)item;
                    equipmentSlot = equipable.m_40402_();
                } else {
                    equipmentSlot = EquipmentSlot.MAINHAND;
                }
            }
            if (eventSlot != equipmentSlot) continue;
            event.removeModifier(visionAttribute.attribute(), visionAttribute.attributeModifier());
            event.addModifier(visionAttribute.attribute(), visionAttribute.attributeModifier());
        }
    }
}

