/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen.util.loottable;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.lixir.vminus.datagen.BlockLootTable;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.BlockEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public abstract class VBlockLootProvider
extends BlockLootSubProvider {
    private final String modId;

    public VBlockLootProvider(String modId) {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    protected void m_245660_() {
        List<Block> blocks = VRegistry.fromId(this.modId).getBlocks();
        for (Block block : blocks) {
            BlockLootTable lootTable;
            BlockEntryAccessor accessor;
            BlockEntry blockEntry;
            if (block.m_60589_().equals((Object)BuiltInLootTables.f_78712_) || (blockEntry = (accessor = (BlockEntryAccessor)block).vminus$getEntry()) == null || (lootTable = blockEntry.getLootTable()).isEmpty()) continue;
            lootTable.apply(block, blockEntry, this);
        }
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return VRegistry.fromId(this.modId).getBlocks().stream().filter(block -> {
            if (block.m_60589_().equals((Object)BuiltInLootTables.f_78712_)) {
                return false;
            }
            BlockEntry blockEntry = ((BlockEntryAccessor)block).vminus$getEntry();
            if (blockEntry == null) {
                return false;
            }
            BlockLootTable lootTable = blockEntry.getLootTable();
            return !lootTable.isEmpty();
        }).toList();
    }

    public void doubleFlower(DoublePlantBlock block) {
        EnumProperty half = DoublePlantBlock.f_52858_;
        this.m_247577_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)half, (Comparable)DoubleBlockHalf.LOWER)))))));
    }

    public void doublePlantShears(Block block) {
        this.m_247577_(block, VBlockLootProvider.m_246463_((Block)block));
    }

    public void shears(Block block) {
        this.m_247577_(block, VBlockLootProvider.m_245929_((ItemLike)block));
    }

    public void self(Block block) {
        this.m_245724_(block);
    }

    public void pinkPetalsShears(PinkPetalsBlock block) {
        IntegerProperty amount = PinkPetalsBlock.f_271373_;
        this.m_247577_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 1)))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 2)))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 3)))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 4)))))));
    }

    public void pinkPetals(PinkPetalsBlock block) {
        IntegerProperty amount = PinkPetalsBlock.f_271373_;
        this.m_247577_((Block)block, LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 1)))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 2)))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 3)))).m_79076_(LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)amount, 4)))))));
    }

    public <T> Optional<T> as(@NotNull Class<T> clazz) {
        return clazz.isInstance((Object)this) ? Optional.of(clazz.cast((Object)this)) : Optional.empty();
    }
}

