/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen.util;

import java.util.Collections;
import java.util.Map;
import net.lixir.vminus.mixins.data.language.LanguageProviderAccessor;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.RegistryEntry;
import net.lixir.vminus.registry.entry.accessor.BlockEntryAccessor;
import net.lixir.vminus.registry.entry.accessor.EntityEntryAccessor;
import net.lixir.vminus.registry.entry.accessor.ItemEntryAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VLangProvider
extends LanguageProvider {
    private final String modId;

    public VLangProvider(PackOutput output, String modId, String locale) {
        super(output, modId, locale);
        this.modId = modId;
    }

    protected void addTranslations() {
        RegistryEntry entry;
        for (Block block : VRegistry.fromId(this.modId).getBlocks()) {
            entry = ((BlockEntryAccessor)block).vminus$getEntry();
            if (entry == null) continue;
            this.handleEntry(block, BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_(), entry);
        }
        for (Item item : VRegistry.fromId(this.modId).getItems()) {
            entry = ((ItemEntryAccessor)item).vminus$getEntry();
            if (entry == null) continue;
            this.handleEntry(item, BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_(), entry);
        }
        for (EntityType entityType : VRegistry.fromId(this.modId).getEntityTypes()) {
            entry = ((EntityEntryAccessor)entityType).vminus$getEntry();
            if (entry == null) continue;
            this.handleEntry(entityType, BuiltInRegistries.f_256780_.m_7981_((Object)entityType).m_135815_(), entry);
        }
    }

    protected void gamerule(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GameRules.Key<?> rule, String name) {
        this.gamerule(rule, name, null);
    }

    protected void subtitle(String name, String translation) {
        this.add("subtitles." + name, translation);
    }

    protected void gamerule(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GameRules.Key<?> rule, String name, @Nullable String description) {
        String id = rule.m_46328_();
        this.add("gamerule." + id, name);
        if (description != null) {
            this.add("gamerule." + id + ".description", description);
        }
    }

    private <E extends RegistryEntry<E, T>, T> void handleEntry(Object object, String idPath, @NotNull RegistryEntry<E, T> entry) {
        String langKey = entry.getLang();
        if (langKey == null || this.has(langKey)) {
            return;
        }
        if (langKey.equals("default")) {
            String name = VLangProvider.toTitleCase(idPath.replace('_', ' '));
            if (object instanceof Block) {
                Block block = (Block)object;
                this.add(block, name);
            } else if (object instanceof Item) {
                Item item = (Item)object;
                this.add(item, name);
            } else if (object instanceof EntityType) {
                EntityType entityType = (EntityType)object;
                this.add(entityType, name);
            }
        } else if (object instanceof Block) {
            Block block = (Block)object;
            this.add(block, langKey);
        } else if (object instanceof Item) {
            Item item = (Item)object;
            this.add(item, langKey);
        } else if (object instanceof EntityType) {
            EntityType entityType = (EntityType)object;
            this.add(entityType, langKey);
        }
    }

    private static String toTitleCase(String input) {
        String[] words = input.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    public boolean has(String key) {
        return this.getTranslations().containsKey(key);
    }

    protected Map<String, String> getTranslations() {
        return Collections.unmodifiableMap(((LanguageProviderAccessor)((Object)this)).getData());
    }

    protected void flavor(Item item, String text) {
        String rawItemId = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString().replaceAll(":", ".");
        String[] split = rawItemId.split("\\.");
        String modId = split[0];
        String itemId = split[1];
        String inspectKey = "item." + modId + "." + itemId + ".flavor";
        this.add(inspectKey, text);
    }

    protected void inspect(Item item, int index, String text) {
        String rawItemId = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString().replaceAll(":", ".");
        String[] split = rawItemId.split("\\.");
        String modId = split[0];
        String itemId = split[1];
        String inspectKey = "item." + modId + "." + itemId + ".inspection." + index;
        this.add(inspectKey, text);
    }

    public void add(@NotNull String key, @NotNull String value) {
        Map<String, String> data = ((LanguageProviderAccessor)((Object)this)).getData();
        if (!this.has(key)) {
            data.put(key, value);
        }
    }
}

