/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen.util;

import java.util.Optional;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.datagen.ItemModel;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.ItemEntry;
import net.lixir.vminus.registry.entry.accessor.ItemEntryAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class VItemModelProvider
extends ItemModelProvider {
    private final String modId;

    public VItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId) {
        super(output, modId, existingFileHelper);
        this.modId = modId;
    }

    protected void registerModels() {
        for (Item item : VRegistry.fromId(this.modId).getItems()) {
            ItemModel model;
            ItemEntryAccessor accessor = (ItemEntryAccessor)item;
            ItemEntry itemEntry = accessor.vminus$getEntry();
            if (itemEntry == null || (model = itemEntry.getModel()).equals(ItemModel.UNSET) || model.equals(ItemModel.NONE)) continue;
            ItemModel.Data itemModelData = new ItemModel.Data(item, itemEntry);
            VMinus.LOGGER.debug("Generating {} for {}", (Object)model, (Object)item);
            model.apply(itemModelData, this);
        }
    }

    public void fromBlockParent(Item item) {
        ResourceLocation itemId;
        ResourceLocation blockId;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
            itemId = ForgeRegistries.ITEMS.getKey((Object)blockItem);
            if (blockId == null || itemId == null) {
                throw new IllegalStateException("Unregistered block or item: " + blockItem);
            }
        } else {
            throw new IllegalArgumentException("Item should be a BlockItem type for From Block Parent model");
        }
        this.withExistingParent(itemId.m_135815_(), this.modLoc("block/" + blockId.m_135815_()));
    }

    public void handheld(Item item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation(this.modId, "item/" + id.m_135815_()));
    }

    public void basicNotBlock(Item item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        String path = "item/" + id.m_135815_();
        ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation(this.modId, path));
    }

    public void basic(Item item, @NotNull ItemEntry itemEntry) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        String path = itemEntry.isFromBlock() ? "block/" + id.m_135815_() : "item/" + id.m_135815_();
        ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation(this.modId, path));
    }

    public void doublePane(Item item) {
        String blockPath;
        BlockItem blockItem;
        if (item instanceof BlockItem) {
            blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            blockPath = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
            if (blockPath.endsWith("_pane")) {
                blockPath = blockPath.substring(0, blockPath.indexOf("_pane"));
            }
        } else {
            throw new IllegalArgumentException("Item should be a BlockItem type for Double Pane ItemModel");
        }
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.f_257033_.m_7981_((Object)blockItem).m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation(this.modId, "block/" + blockPath + "_top"));
    }

    public void pane(Item item) {
        String blockPath;
        BlockItem blockItem;
        if (item instanceof BlockItem) {
            blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            blockPath = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
            if (blockPath.endsWith("_pane")) {
                blockPath = blockPath.substring(0, blockPath.indexOf("_pane"));
            }
        } else {
            throw new IllegalArgumentException("Item should be a BlockItem type for Pane ItemModel");
        }
        ((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.f_257033_.m_7981_((Object)blockItem).m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation(this.modId, "block/" + blockPath));
    }

    public <T> Optional<T> as(@NotNull Class<T> clazz) {
        return clazz.isInstance((Object)this) ? Optional.of(clazz.cast((Object)this)) : Optional.empty();
    }
}

